/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.base;

import java.util.Arrays;

public class Base32 {
    private static final String ALPHABET = "0123456789ABCDEFGHJKMNPQRSTVWXYZ";
    private static final byte[] ENCODE_MAP = "0123456789ABCDEFGHJKMNPQRSTVWXYZ".getBytes();
    private static final byte[] DECODE_MAP = new byte[128];

    public static String encode(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int buffer = 0;
        int bitsLeft = 0;
        for (byte b : bytes) {
            buffer = buffer << 8 | b & 0xFF;
            bitsLeft += 8;
            while (bitsLeft >= 5) {
                result.append((char)ENCODE_MAP[buffer >> bitsLeft - 5 & 0x1F]);
                bitsLeft -= 5;
            }
        }
        if (bitsLeft > 0) {
            result.append((char)ENCODE_MAP[(buffer <<= 5 - bitsLeft) & 0x1F]);
        }
        return result.toString();
    }

    public static byte[] decode(String str) {
        if (str == null || str.isEmpty()) {
            return new byte[0];
        }
        str = str.replace("-", "");
        int bitLength = str.length() * 5;
        int byteLength = (bitLength + 7) / 8;
        byte[] result = new byte[byteLength];
        int buffer = 0;
        int bitsLeft = 0;
        int index = 0;
        for (char c : str.toCharArray()) {
            if (c >= DECODE_MAP.length || DECODE_MAP[c] < 0) {
                throw new IllegalArgumentException("Invalid character in Base32 string: " + c);
            }
            buffer = buffer << 5 | DECODE_MAP[c];
            if ((bitsLeft += 5) < 8) continue;
            result[index++] = (byte)(buffer >> bitsLeft - 8 & 0xFF);
            bitsLeft -= 8;
        }
        return result;
    }

    static {
        Arrays.fill(DECODE_MAP, (byte)-1);
        for (int i = 0; i < ENCODE_MAP.length; ++i) {
            Base32.DECODE_MAP[Base32.ENCODE_MAP[i]] = (byte)i;
            if (!Character.isLetter((char)ENCODE_MAP[i])) continue;
            Base32.DECODE_MAP[Character.toLowerCase((char)((char)Base32.ENCODE_MAP[i]))] = (byte)i;
        }
        Base32.DECODE_MAP[73] = DECODE_MAP[49];
        Base32.DECODE_MAP[105] = DECODE_MAP[49];
        Base32.DECODE_MAP[76] = DECODE_MAP[49];
        Base32.DECODE_MAP[108] = DECODE_MAP[49];
        Base32.DECODE_MAP[79] = DECODE_MAP[48];
        Base32.DECODE_MAP[111] = DECODE_MAP[48];
    }
}

