/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.mist;

import icu.congee.id.base.IdType;
import icu.congee.id.generator.mist.MistGenerator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;

public class StandardMistGenerator
implements MistGenerator {
    private static final int SALT_BIT = 8;
    private static final int SALT_SHIFT = 8;
    private static final int INCREAS_SHIFT = 16;
    private static final int MAX_SALT_VALUE = 255;
    private final AtomicLong increas = new AtomicLong(1L);
    private final ThreadLocalRandom random = ThreadLocalRandom.current();

    @Override
    public Long generate() {
        long increasValue = this.increas.incrementAndGet();
        long saltA = this.random.nextInt(256);
        long saltB = this.random.nextInt(256);
        return increasValue << 16 | saltA << 8 | saltB;
    }

    public static StandardMistGenerator getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public IdType idType() {
        return IdType.MIST_ID;
    }

    private static class SingletonHolder {
        private static final StandardMistGenerator INSTANCE = new StandardMistGenerator();

        private SingletonHolder() {
        }
    }
}

