/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.sonyflake;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

public class Sonyflake {
    private static final int BIT_LEN_TIME = 39;
    private static final int BIT_LEN_SEQUENCE = 8;
    private static final int BIT_LEN_MACHINE_ID = 16;
    private static final long SONYFLAKE_TIME_UNIT = 10000000L;
    private static final long DEFAULT_START_TIME = Sonyflake.toSonyflakeTime(new GregorianCalendar(2014, 8, 1, 0, 0, 0).getTime());
    private final Object mutex = new Object();
    private long startTime = 0L;
    private long elapsedTime = 0L;
    private short sequence = 0;
    private short machineID = 0;

    public static Sonyflake newInstance(Settings st) throws StartTimeAheadException, NoPrivateAddressException, InvalidMachineIDException {
        short machineID;
        if (st.startTime != null && st.startTime.after(new Date())) {
            throw new StartTimeAheadException();
        }
        Sonyflake sf = new Sonyflake();
        sf.sequence = (short)255;
        sf.startTime = st.startTime == null ? DEFAULT_START_TIME : Sonyflake.toSonyflakeTime(st.startTime);
        try {
            machineID = st.machineIDSupplier == null ? Sonyflake.lower16BitPrivateIP() : st.machineIDSupplier.get();
        }
        catch (Exception e) {
            throw new NoPrivateAddressException();
        }
        if (st.machineIDValidator != null && !st.machineIDValidator.validate(machineID)) {
            throw new InvalidMachineIDException();
        }
        sf.machineID = machineID;
        return sf;
    }

    public static Sonyflake newSonyflake(Settings st) {
        try {
            return Sonyflake.newInstance(st);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextID() throws OverTimeLimitException {
        int maskSequence = 255;
        Object object = this.mutex;
        synchronized (object) {
            long current = Sonyflake.currentElapsedTime(this.startTime);
            if (this.elapsedTime < current) {
                this.elapsedTime = current;
                this.sequence = 0;
            } else {
                this.sequence = (short)(this.sequence + 1 & 0xFF);
                if (this.sequence == 0) {
                    ++this.elapsedTime;
                    long overtime = this.elapsedTime - current;
                    try {
                        Thread.sleep(Sonyflake.sleepTime(overtime));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            return this.toID();
        }
    }

    private static long toSonyflakeTime(Date t) {
        return t.toInstant().toEpochMilli() * 1000000L / 10000000L;
    }

    private static long currentElapsedTime(long startTime) {
        return Sonyflake.toSonyflakeTime(new Date()) - startTime;
    }

    private static long sleepTime(long overtime) {
        return overtime * 10000000L - System.nanoTime() % 10000000L;
    }

    private long toID() throws OverTimeLimitException {
        if (this.elapsedTime >= 0x8000000000L) {
            throw new OverTimeLimitException();
        }
        return this.elapsedTime << 24 | (long)this.sequence << 16 | (long)this.machineID;
    }

    private static byte[] privateIPv4() throws NoPrivateAddressException {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    byte[] ip;
                    InetAddress address = addresses.nextElement();
                    if (address.isLoopbackAddress() || address.getAddress().length != 4 || !Sonyflake.isPrivateIPv4(ip = address.getAddress())) continue;
                    return ip;
                }
            }
        }
        catch (SocketException e) {
            throw new NoPrivateAddressException();
        }
        throw new NoPrivateAddressException();
    }

    private static boolean isPrivateIPv4(byte[] ip) {
        return ip != null && (ip[0] == 10 || ip[0] == -84 && ip[1] >= 16 && ip[1] < 32 || ip[0] == -64 && ip[1] == -88 || ip[0] == -87 && ip[1] == -2);
    }

    private static short lower16BitPrivateIP() throws NoPrivateAddressException {
        byte[] ip = Sonyflake.privateIPv4();
        return (short)((ip[2] & 0xFF) << 8 | ip[3] & 0xFF);
    }

    public static long elapsedTime(long id) {
        return id >> 24;
    }

    public static long sequenceNumber(long id) {
        long maskSequence = 0xFF0000L;
        return (id & 0xFF0000L) >> 16;
    }

    public static long machineID(long id) {
        long maskMachineID = 65535L;
        return id & 0xFFFFL;
    }

    public static Map<String, Long> decompose(long id) {
        long msb = id >> 63;
        long time = Sonyflake.elapsedTime(id);
        long sequence = Sonyflake.sequenceNumber(id);
        long machineID = Sonyflake.machineID(id);
        HashMap<String, Long> result = new HashMap<String, Long>();
        result.put("id", id);
        result.put("msb", msb);
        result.put("time", time);
        result.put("sequence", sequence);
        result.put("machine-id", machineID);
        return result;
    }

    private Sonyflake() {
    }

    public static class Settings {
        public Date startTime = null;
        public MachineIDSupplier machineIDSupplier = null;
        public MachineIDValidator machineIDValidator = null;
    }

    public static class StartTimeAheadException
    extends Exception {
        public StartTimeAheadException() {
            super("start time is ahead of now");
        }
    }

    @FunctionalInterface
    public static interface MachineIDSupplier {
        public short get() throws Exception;
    }

    public static class NoPrivateAddressException
    extends Exception {
        public NoPrivateAddressException() {
            super("no private ip address");
        }
    }

    @FunctionalInterface
    public static interface MachineIDValidator {
        public boolean validate(short var1);
    }

    public static class InvalidMachineIDException
    extends Exception {
        public InvalidMachineIDException() {
            super("invalid machine id");
        }
    }

    public static class OverTimeLimitException
    extends Exception {
        public OverTimeLimitException() {
            super("over the time limit");
        }
    }
}

