/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.demo.task;

import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import icu.congee.id.generator.distributed.atomiclong.AtomicLongIdGenerator;
import icu.congee.id.generator.distributed.cosid.CosIdGenerator;
import icu.congee.id.generator.distributed.mist.MistIdGenerator;
import icu.congee.id.generator.distributed.rid.RedissonIdGenerator;
import icu.congee.id.generator.distributed.snowflake.SnowflakeIdGenerator;
import jakarta.annotation.Resource;
import java.util.concurrent.locks.LockSupport;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class IdGeneratorTask
implements CommandLineRunner {
    Log log = LogFactory.get();
    @Resource
    RedissonIdGenerator redissonIdGenerator;
    @Resource
    SnowflakeIdGenerator snowflakeIdGenerator;
    @Resource
    MistIdGenerator mistIdGenerator;
    @Resource
    AtomicLongIdGenerator atomicLongIdGenerator;
    @Resource
    CosIdGenerator cosIdGenerator;

    public void run(String ... args) {
        int i = 0;
        while (i < 10) {
            this.log.info("redisson id: {}", new Object[]{this.redissonIdGenerator.generate()});
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.log.info("snowflake id: {}", new Object[]{this.snowflakeIdGenerator.generate()});
            LockSupport.parkNanos(1000000000L);
            ++i;
        }
        i = 0;
        while (i < 10) {
            this.log.info("mist id: {}", new Object[]{this.mistIdGenerator.generate()});
            ++i;
        }
        i = 0;
        while (i < 10) {
            this.log.info("atomic long id: {}", new Object[]{this.atomicLongIdGenerator.generate()});
            ++i;
        }
        i = 0;
        while (i < 10) {
            this.log.info("cos id: {}", new Object[]{this.cosIdGenerator.generate().toBase62()});
            ++i;
        }
    }
}

