/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.demo.task;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.log.Log;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.demo.entity.IdGeneratorDistributedEntity;
import icu.congee.id.generator.demo.service.IdGeneratorDistributedService;
import icu.congee.id.generator.distributed.atomiclong.AtomicLongIdGenerator;
import icu.congee.id.generator.distributed.cosid.CosIdGenerator;
import icu.congee.id.generator.distributed.dtsid.DtsIdGenerator;
import icu.congee.id.generator.distributed.mist.MistIdGenerator;
import icu.congee.id.generator.distributed.rid.RedissonIdGenerator;
import icu.congee.id.generator.distributed.snowflake.SnowflakeIdGenerator;
import icu.congee.id.generator.distributed.ttsid.TtsIdGenerator;
import icu.congee.id.generator.distributed.ttsid.TtsIdPlusGenerator;
import icu.congee.id.generator.distributed.ttsid.TtsIdProGenerator;
import icu.congee.id.generator.distributed.ttsid.TtsIdProMaxGenerator;
import icu.congee.id.generator.distributed.uuid.UUIDv8Generator;
import icu.congee.id.generator.distributed.wxseq.WxSeqGenerator;
import jakarta.annotation.Resource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class IdGeneratorDistributedTask {
    private final Log log = Log.get();
    @Resource
    private IdGeneratorDistributedService idGeneratorDistributedService;
    @Resource
    private AtomicLongIdGenerator atomicLongIdGenerator;
    @Resource
    private CosIdGenerator cosIdGenerator;
    @Resource
    private DtsIdGenerator dtsIdGenerator;
    @Resource
    private MistIdGenerator mistIdGenerator;
    @Resource
    private RedissonIdGenerator redissonIdGenerator;
    @Resource
    private SnowflakeIdGenerator snowflakeIdGenerator;
    @Resource
    private TtsIdGenerator ttsIdGenerator;
    @Resource
    private TtsIdPlusGenerator ttsIdPlusGenerator;
    @Resource
    private TtsIdProGenerator ttsIdProGenerator;
    @Resource
    private TtsIdProMaxGenerator ttsIdProMaxGenerator;
    @Resource
    private WxSeqGenerator wxSeqGenerator;
    @Resource
    private UUIDv8Generator uuiDv8Generator;

    @Scheduled(cron="* * * * * ?")
    public void generate() {
        Long id = this.atomicLongIdGenerator.generate();
        this.log.info("{}", new Object[]{id});
        IdGeneratorDistributedEntity idGeneratorDistributedEntity = new IdGeneratorDistributedEntity();
        idGeneratorDistributedEntity.setIdType(IdType.RAtomicLong.getName());
        idGeneratorDistributedEntity.setBase10(id.toString());
        this.idGeneratorDistributedService.save(idGeneratorDistributedEntity);
        id = this.cosIdGenerator.generate();
        this.log.info("{}", new Object[]{id});
        idGeneratorDistributedEntity = new IdGeneratorDistributedEntity();
        idGeneratorDistributedEntity.setIdType(IdType.CosId.getName());
        idGeneratorDistributedEntity.setBase64(id.toBase62());
        idGeneratorDistributedEntity.setBase64(id.toBase36());
        this.idGeneratorDistributedService.save(idGeneratorDistributedEntity);
        id = this.dtsIdGenerator.generate();
        this.log.info("{}", new Object[]{id});
        idGeneratorDistributedEntity = new IdGeneratorDistributedEntity();
        idGeneratorDistributedEntity.setIdType(IdType.DtsId.getName());
        idGeneratorDistributedEntity.setBase10(String.valueOf(id.toLong()));
        this.idGeneratorDistributedService.save(idGeneratorDistributedEntity);
        id = this.mistIdGenerator.generate();
        this.log.info("{}", new Object[]{id});
        idGeneratorDistributedEntity = new IdGeneratorDistributedEntity();
        idGeneratorDistributedEntity.setIdType(IdType.MIST_ID.getName());
        idGeneratorDistributedEntity.setBase10(String.valueOf(id));
        this.idGeneratorDistributedService.save(idGeneratorDistributedEntity);
        id = this.mistIdGenerator.generate();
        this.log.info("{}", new Object[]{id});
        idGeneratorDistributedEntity = new IdGeneratorDistributedEntity();
        idGeneratorDistributedEntity.setIdType(IdType.MIST_ID.getName());
        idGeneratorDistributedEntity.setBase10(String.valueOf(id));
        this.idGeneratorDistributedService.save(idGeneratorDistributedEntity);
        id = this.redissonIdGenerator.generate();
        this.log.info("{}", new Object[]{id});
        idGeneratorDistributedEntity = new IdGeneratorDistributedEntity();
        idGeneratorDistributedEntity.setIdType(IdType.RID.getName());
        idGeneratorDistributedEntity.setBase10(String.valueOf(id));
        this.idGeneratorDistributedService.save(idGeneratorDistributedEntity);
        id = this.snowflakeIdGenerator.generate();
        this.log.info("{}", new Object[]{id});
        idGeneratorDistributedEntity = new IdGeneratorDistributedEntity();
        idGeneratorDistributedEntity.setIdType(IdType.Snowflake.getName());
        idGeneratorDistributedEntity.setBase10(String.valueOf(id));
        this.idGeneratorDistributedService.save(idGeneratorDistributedEntity);
        id = this.snowflakeIdGenerator.generate();
        this.log.info("{}", new Object[]{id});
        idGeneratorDistributedEntity = new IdGeneratorDistributedEntity();
        idGeneratorDistributedEntity.setIdType(IdType.Snowflake.getName());
        idGeneratorDistributedEntity.setBase10(String.valueOf(id));
        this.idGeneratorDistributedService.save(idGeneratorDistributedEntity);
        id = this.ttsIdGenerator.generate();
        this.log.info("{}", new Object[]{id});
        idGeneratorDistributedEntity = new IdGeneratorDistributedEntity();
        idGeneratorDistributedEntity.setIdType(IdType.TtsId.getName());
        idGeneratorDistributedEntity.setBytes(id.toBytes());
        idGeneratorDistributedEntity.setBase64(id.toBase64());
        idGeneratorDistributedEntity.setBase62(id.toBase62());
        idGeneratorDistributedEntity.setBase36(id.toBase36());
        idGeneratorDistributedEntity.setBase32(id.toBase32());
        idGeneratorDistributedEntity.setBase16(id.toBase16());
        idGeneratorDistributedEntity.setBase10(id.toBase10());
        this.idGeneratorDistributedService.save(idGeneratorDistributedEntity);
        id = this.ttsIdPlusGenerator.generate();
        this.log.info("{}", new Object[]{id});
        idGeneratorDistributedEntity = new IdGeneratorDistributedEntity();
        idGeneratorDistributedEntity.setIdType(IdType.TtsId.getName());
        idGeneratorDistributedEntity.setBytes(id.toBytes());
        idGeneratorDistributedEntity.setBase64(id.toBase64());
        idGeneratorDistributedEntity.setBase62(id.toBase62());
        idGeneratorDistributedEntity.setBase36(id.toBase36());
        idGeneratorDistributedEntity.setBase32(id.toBase32());
        idGeneratorDistributedEntity.setBase16(id.toBase16());
        idGeneratorDistributedEntity.setBase10(id.toBase10());
        this.idGeneratorDistributedService.save(idGeneratorDistributedEntity);
        id = this.ttsIdProGenerator.generate();
        this.log.info("{}", new Object[]{id});
        idGeneratorDistributedEntity = new IdGeneratorDistributedEntity();
        idGeneratorDistributedEntity.setIdType(IdType.TtsId.getName());
        idGeneratorDistributedEntity.setBytes(id.toBytes());
        idGeneratorDistributedEntity.setBase64(id.toBase64());
        idGeneratorDistributedEntity.setBase62(id.toBase62());
        idGeneratorDistributedEntity.setBase36(id.toBase36());
        idGeneratorDistributedEntity.setBase32(id.toBase32());
        idGeneratorDistributedEntity.setBase16(id.toBase16());
        idGeneratorDistributedEntity.setBase10(id.toBase10());
        this.idGeneratorDistributedService.save(idGeneratorDistributedEntity);
        id = this.ttsIdProMaxGenerator.generate();
        this.log.info("{}", new Object[]{id});
        idGeneratorDistributedEntity = new IdGeneratorDistributedEntity();
        idGeneratorDistributedEntity.setIdType(IdType.TtsId.getName());
        idGeneratorDistributedEntity.setBytes(id.toBytes());
        idGeneratorDistributedEntity.setBase64(id.toBase64());
        idGeneratorDistributedEntity.setBase62(id.toBase62());
        idGeneratorDistributedEntity.setBase36(id.toBase36());
        idGeneratorDistributedEntity.setBase32(id.toBase32());
        idGeneratorDistributedEntity.setBase16(id.toBase16());
        idGeneratorDistributedEntity.setBase10(id.toBase10());
        this.idGeneratorDistributedService.save(idGeneratorDistributedEntity);
        id = this.wxSeqGenerator.generate(Long.valueOf(RandomUtil.randomLong((long)1L, (long)10L)));
        this.log.info("{}", new Object[]{id});
        idGeneratorDistributedEntity = new IdGeneratorDistributedEntity();
        idGeneratorDistributedEntity.setIdType(IdType.WxSeq.getName());
        idGeneratorDistributedEntity.setBytes(id.toBytes());
        idGeneratorDistributedEntity.setBase64(id.toBase64());
        idGeneratorDistributedEntity.setBase62(id.toBase62());
        idGeneratorDistributedEntity.setBase36(id.toBase36());
        idGeneratorDistributedEntity.setBase32(id.toBase32());
        idGeneratorDistributedEntity.setBase16(id.toBase16());
        idGeneratorDistributedEntity.setBase10(id.toBase10());
        this.idGeneratorDistributedService.save(idGeneratorDistributedEntity);
        id = this.uuiDv8Generator.generate();
        this.log.info("{}", new Object[]{id});
        idGeneratorDistributedEntity = new IdGeneratorDistributedEntity();
        idGeneratorDistributedEntity.setIdType(IdType.UUIDv8.getName());
        idGeneratorDistributedEntity.setBytes(id.toBytes());
        this.idGeneratorDistributedService.save(idGeneratorDistributedEntity);
    }
}

