/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.atomiclong;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"redissonClient"})
public enum AtomicLongIdGenerator implements IdGenerator
{
    INSTANCE;

    @Resource
    private RedissonClient redisson;
    private RAtomicLong atomicLong;

    @PostConstruct
    public void init() {
        this.atomicLong = this.redisson.getAtomicLong("IdGenerator:AtomicLongIdGenerator:current");
    }

    public Long generate() {
        return this.atomicLong.incrementAndGet();
    }

    public IdType idType() {
        return IdType.RAtomicLong;
    }
}

