/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.cosid;

import icu.congee.id.base.Id;
import java.nio.ByteBuffer;
import lombok.Generated;

public class CosId
implements Id {
    private long timestamp;
    private long machineId;
    private long sequence;

    public CosId(long timestamp, long machineId, long sequence) {
        this.timestamp = timestamp;
        this.machineId = machineId;
        this.sequence = sequence;
    }

    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        buffer.put((byte)(this.timestamp >>> 36));
        buffer.put((byte)(this.timestamp >>> 28 & 0xFFL));
        buffer.put((byte)(this.timestamp >>> 20 & 0xFFL));
        buffer.put((byte)(this.timestamp >>> 12 & 0xFFL));
        buffer.put((byte)(this.timestamp >>> 4 & 0xFFL));
        byte sixthByte = (byte)((this.timestamp & 0xFL) << 4);
        sixthByte = (byte)(sixthByte | (byte)(this.machineId >>> 16 & 0xFL));
        buffer.put(sixthByte);
        buffer.putShort((short)(this.machineId & 0xFFFFL));
        buffer.putShort((short)this.sequence);
        return buffer.array();
    }

    public long toLong() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public long getMachineId() {
        return this.machineId;
    }

    @Generated
    public long getSequence() {
        return this.sequence;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setMachineId(long machineId) {
        this.machineId = machineId;
    }

    @Generated
    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CosId)) {
            return false;
        }
        CosId other = (CosId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getMachineId() != other.getMachineId()) {
            return false;
        }
        return this.getSequence() == other.getSequence();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CosId;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $machineId = this.getMachineId();
        result = result * 59 + (int)($machineId >>> 32 ^ $machineId);
        long $sequence = this.getSequence();
        result = result * 59 + (int)($sequence >>> 32 ^ $sequence);
        return result;
    }

    @Generated
    public String toString() {
        return "CosId(timestamp=" + this.getTimestamp() + ", machineId=" + this.getMachineId() + ", sequence=" + this.getSequence() + ")";
    }
}

