/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.cosid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.distributed.cosid.CosId;
import icu.congee.id.generator.service.MachineIdService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public enum CosIdGenerator implements IdGenerator
{
    INSTANCE;

    private static final long MAX_SEQUENCE = 2048L;
    private final AtomicLong currentSequence = new AtomicLong(0L);
    private volatile long lastTimestamp = -1L;
    @Value(value="${id.generator.cosid.epoch:1672502400000}")
    private long epoch;
    @Resource
    private RedissonClient redisson;
    private MachineIdService machineIdService;

    @PostConstruct
    public void init() {
        this.machineIdService = new MachineIdService(this.redisson, IdType.CosId.getName());
    }

    private void waitNextMillis(long lastTimestamp) {
        long timestamp = this.getCurrentTimestamp();
        while (timestamp <= lastTimestamp) {
            timestamp = this.getCurrentTimestamp();
        }
    }

    private long getCurrentTimestamp() {
        return System.currentTimeMillis() - this.epoch;
    }

    public synchronized CosId generate() {
        long timestamp = this.getCurrentTimestamp();
        if (timestamp < this.lastTimestamp) {
            long backwardMillis = this.lastTimestamp - timestamp;
            String errorMessage = String.format("\u65f6\u949f\u56de\u62e8\uff0c\u62d2\u7edd\u751f\u6210ID\uff0c\u56de\u62e8\u65f6\u95f4\uff1a%d\u6beb\u79d2", backwardMillis);
            throw new ClockMovedBackwardsException(errorMessage);
        }
        if (timestamp == this.lastTimestamp) {
            long sequence = this.currentSequence.get();
            if (sequence >= 2048L) {
                this.waitNextMillis(this.lastTimestamp);
                timestamp = this.getCurrentTimestamp();
                this.currentSequence.set(0L);
            }
        } else {
            this.currentSequence.set(0L);
        }
        this.lastTimestamp = timestamp;
        return new CosId(timestamp, this.machineIdService.get(), this.currentSequence.getAndIncrement());
    }

    public IdType idType() {
        return IdType.CosId;
    }

    public static class ClockMovedBackwardsException
    extends RuntimeException {
        public ClockMovedBackwardsException(String message) {
            super(message);
        }
    }
}

