/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.snowflake;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.service.MachineIdService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public enum SnowflakeIdGenerator implements IdGenerator
{
    INSTANCE;

    private final AtomicLong currentSequence = new AtomicLong(0L);
    private final String uuid = UUID.randomUUID().toString();
    @Value(value="${id.generator.snowflake.epoch:1645557742000}")
    private long epoch;
    @Value(value="${id.generator.snowflake.timestamp:41}")
    private long timestampBits;
    @Value(value="${id.generator.snowflake.machine:10}")
    private long machineIdBits;
    @Value(value="${id.generator.snowflake.sequence:12}")
    private long sequenceBits;
    private volatile long lastTimestamp = -1L;
    @Resource
    private RedissonClient redisson;
    private MachineIdService machineIdService;

    @PostConstruct
    public void init() {
        this.machineIdService = new MachineIdService(this.redisson, IdType.Snowflake.getName());
    }

    private void waitNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
    }

    public Long generate() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            timestamp = this.lastTimestamp;
        }
        if (timestamp == this.lastTimestamp) {
            long sequence = this.currentSequence.get();
            if (sequence >= 1L << (int)(this.sequenceBits - 1L)) {
                this.waitNextMillis(this.lastTimestamp);
                timestamp = System.currentTimeMillis();
                this.currentSequence.set(0L);
            }
        } else {
            this.currentSequence.set(0L);
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.epoch << (int)(this.machineIdBits + this.sequenceBits) | this.machineIdService.get() << (int)this.sequenceBits | this.currentSequence.getAndIncrement();
    }

    public IdType idType() {
        return IdType.Snowflake;
    }
}

