/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.service;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.redisson.api.RSetCache;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MachineIdService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MachineIdService.class);
    private final RSetCache<Long> set;
    private final long machineId;

    public MachineIdService(RedissonClient redisson, String namespace) {
        String name = "IdGenerator:MachineIdService:%s:Set".formatted(namespace);
        this.set = redisson.getSetCache(name);
        this.machineId = this.register();
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.scheduleAtFixedRate(this::renewLease, 10L, 20L, TimeUnit.SECONDS);
    }

    public void renewLease() {
        this.set.add((Object)this.machineId, 60L, TimeUnit.SECONDS);
        log.info("renew machine id:{}", (Object)this.machineId);
    }

    public long register() {
        long id = 0L;
        while (this.set.contains((Object)id)) {
            ++id;
        }
        this.set.add((Object)id, 60L, TimeUnit.SECONDS);
        log.info("register machine id:{}", (Object)id);
        return id;
    }

    public long get() {
        return this.machineId;
    }
}

