/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.cosid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.distributed.cosid.CosId;
import icu.congee.id.generator.service.MachineIdService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public enum CosIdGenerator implements IdGenerator
{
    INSTANCE;

    @Value(value="${id.generator.cosid.timestamp.bits:44}")
    private int timestampBits;
    @Value(value="${id.generator.cosid.machine.bits:20}")
    private int machineBits;
    @Value(value="${id.generator.cosid.sequence.bits:16}")
    private int sequenceBits;
    private long maxSequence;
    private long currentSequence = 0L;
    private long lastTimestamp = -1L;
    @Value(value="${id.generator.cosid.epoch:1672502400000}")
    private long epoch;
    @Resource
    private RedissonClient redisson;
    private MachineIdService machineIdService;

    @PostConstruct
    public void init() {
        if (this.timestampBits + this.machineBits + this.sequenceBits != 80) {
            throw new IllegalArgumentException(String.format("\u4f4d\u6570\u5206\u914d\u603b\u548c\u5fc5\u987b\u4e3a80\u4f4d\uff0c\u5f53\u524d\u914d\u7f6e\uff1atimestamp=%d, machine=%d, sequence=%d, total=%d", this.timestampBits, this.machineBits, this.sequenceBits, this.timestampBits + this.machineBits + this.sequenceBits));
        }
        this.maxSequence = (1L << this.sequenceBits) - 1L;
        this.machineIdService = new MachineIdService(this.redisson, IdType.CosId.getName());
    }

    private void waitNextMillis(long lastTimestamp) {
        long timestamp = this.getCurrentTimestamp();
        while (timestamp <= lastTimestamp) {
            timestamp = this.getCurrentTimestamp();
        }
    }

    private long getCurrentTimestamp() {
        return System.currentTimeMillis() - this.epoch;
    }

    public synchronized CosId generate() {
        long timestamp = this.getCurrentTimestamp();
        if (timestamp < this.lastTimestamp) {
            long backwardMillis = this.lastTimestamp - timestamp;
            String errorMessage = String.format("\u65f6\u949f\u56de\u62e8\uff0c\u62d2\u7edd\u751f\u6210ID\uff0c\u56de\u62e8\u65f6\u95f4\uff1a%d\u6beb\u79d2", backwardMillis);
            throw new RuntimeException(errorMessage);
        }
        if (timestamp == this.lastTimestamp) {
            if (this.currentSequence >= this.maxSequence) {
                this.waitNextMillis(this.lastTimestamp);
                timestamp = this.getCurrentTimestamp();
                this.currentSequence = 0L;
            }
        } else {
            this.currentSequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return new CosId(timestamp, this.machineIdService.get(), this.currentSequence++, this.timestampBits, this.machineBits, this.sequenceBits);
    }

    public IdType idType() {
        return IdType.CosId;
    }
}

