/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.mist;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.distributed.mist.MistId;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"redissonClient"})
public enum MistIdGenerator implements IdGenerator
{
    INSTANCE;

    @Resource
    private RedissonClient redisson;
    @Value(value="${id.generator.mist.name:IdGenerator:AtomicLongIdGenerator:current}")
    private String name;
    @Value(value="${id.generator.mist.value:-1}")
    private Long value;
    @Value(value="${id.generator.mist.secret:false}")
    private Boolean secret;
    private RAtomicLong atomicLong;
    private Random random;

    @PostConstruct
    public void init() {
        this.atomicLong = this.redisson.getAtomicLong(this.name);
        if (this.value >= 0L) {
            this.atomicLong.set(this.value.longValue());
        }
        this.random = this.secret != false ? new SecureRandom() : ThreadLocalRandom.current();
    }

    public MistId generate() {
        return new MistId(this.atomicLong.getAndIncrement(), this.random.nextInt(256), this.random.nextInt(256));
    }

    public IdType idType() {
        return IdType.MIST_ID;
    }
}

