/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.rid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import org.redisson.api.RIdGenerator;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"redissonClient"})
public enum RedissonIdGenerator implements IdGenerator
{
    INSTANCE;

    @Resource
    private RedissonClient redisson;
    @Value(value="${id.generator.rid.name:IdGenerator:RedissonIdGenerator:current}")
    private String name;
    @Value(value="${id.generator.rid.value:0}")
    private long value;
    @Value(value="${id.generator.rid.allocationSize:5000}")
    private long allocationSize;
    private RIdGenerator generator;

    @PostConstruct
    public void init() {
        this.generator = this.redisson.getIdGenerator(this.name);
        this.generator.tryInit(this.value, this.allocationSize);
    }

    public Long generate() {
        return this.generator.nextId();
    }

    public IdType idType() {
        return IdType.RID;
    }
}

