/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.snowflake;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.service.MachineIdService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public enum SnowflakeIdGenerator implements IdGenerator
{
    INSTANCE;

    @Value(value="${id.generator.snowflake.epoch:1645557742000}")
    private long epoch;
    @Value(value="${id.generator.snowflake.timestamp:41}")
    private long timestampBits;
    @Value(value="${id.generator.snowflake.machine:10}")
    private long machineIdBits;
    @Value(value="${id.generator.snowflake.sequence:12}")
    private long sequenceBits;
    private long lastTimestamp = -1L;
    @Resource
    private RedissonClient redisson;
    private MachineIdService machineIdService;
    private long sequence;

    @PostConstruct
    public void init() {
        this.machineIdService = new MachineIdService(this.redisson, IdType.Snowflake.getName());
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    public synchronized Long generate() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException("\u65f6\u949f\u56de\u62e8\uff0c\u62d2\u7edd\u751f\u6210ID");
        }
        if (timestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & (-1L << (int)this.sequenceBits ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.epoch << (int)(this.machineIdBits + this.sequenceBits) | this.machineIdService.get() << (int)this.sequenceBits | this.sequence;
    }

    public IdType idType() {
        return IdType.Snowflake;
    }
}

