/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.broid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.distributed.broid.BroId;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import lombok.Generated;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;

@Component
public enum BroIdGenerator implements IdGenerator
{
    INSTANCE;

    @Resource
    private RedissonClient redisson;
    private RAtomicLong threadId;
    private ThreadLocal<BroIdThreadLocalHolder> threadLocalHolder;

    @PostConstruct
    public void init() {
        this.threadId = this.redisson.getAtomicLong("IdGenerator:BroIdGenerator:threadId");
        this.threadLocalHolder = ThreadLocal.withInitial(() -> {
            long currentThreadId = this.threadId.getAndIncrement();
            return new BroIdThreadLocalHolder((short)currentThreadId, 0);
        });
    }

    public BroId generate() {
        BroIdThreadLocalHolder broIdThreadLocalHolder = this.threadLocalHolder.get();
        short s = broIdThreadLocalHolder.sequence;
        broIdThreadLocalHolder.sequence = (short)(s + 1);
        return new BroId(BroId.currentTimestamp(), broIdThreadLocalHolder.threadId, s);
    }

    public IdType idType() {
        return IdType.BroId;
    }

    public static class BroIdThreadLocalHolder {
        short threadId;
        short sequence;

        @Generated
        public short getThreadId() {
            return this.threadId;
        }

        @Generated
        public short getSequence() {
            return this.sequence;
        }

        @Generated
        public void setThreadId(short threadId) {
            this.threadId = threadId;
        }

        @Generated
        public void setSequence(short sequence) {
            this.sequence = sequence;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BroIdThreadLocalHolder)) {
                return false;
            }
            BroIdThreadLocalHolder other = (BroIdThreadLocalHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getThreadId() != other.getThreadId()) {
                return false;
            }
            return this.getSequence() == other.getSequence();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BroIdThreadLocalHolder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getThreadId();
            result = result * 59 + this.getSequence();
            return result;
        }

        @Generated
        public String toString() {
            return "BroIdGenerator.BroIdThreadLocalHolder(threadId=" + this.getThreadId() + ", sequence=" + this.getSequence() + ")";
        }

        @Generated
        public BroIdThreadLocalHolder(short threadId, short sequence) {
            this.threadId = threadId;
            this.sequence = sequence;
        }
    }
}

