/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.broid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.broid.BitUtils;
import icu.congee.id.generator.broid.BroIdGenerator;
import icu.congee.id.generator.broid.BroIdLayout;
import icu.congee.id.generator.broid.BroIdPart;
import icu.congee.id.generator.distributed.broid.BroIdCustom;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;

public class BroIdGeneratorCustom
extends BroIdGenerator<BroIdCustom>
implements IdGenerator {
    private RAtomicLong threadId;
    private ThreadLocal<BroIdThreadLocalHolder> threadLocalHolder;

    public BroIdGeneratorCustom(BroIdLayout layout, Function<List<Boolean>, BroIdCustom> constructor) {
        super(layout, constructor);
    }

    public BroIdGeneratorCustom BroIdGeneratorCustom(RedissonClient redisson) {
        this.threadId = redisson.getAtomicLong("IdGenerator:BroIdGenerator:threadId");
        this.threadLocalHolder = ThreadLocal.withInitial(() -> {
            long currentThreadId = this.threadId.getAndIncrement();
            return new BroIdThreadLocalHolder((short)currentThreadId, 0);
        });
        ArrayList<Object> parts = new ArrayList<Object>();
        parts.add(new BroIdPart(){

            public int getBits() {
                return 41;
            }

            public List<Boolean> next() {
                return BitUtils.longToList((long)System.currentTimeMillis(), (int)this.getBits());
            }
        });
        parts.add(new BroIdPart(){

            public int getBits() {
                return 10;
            }

            public List<Boolean> next() {
                return BitUtils.longToList((long)BroIdGeneratorCustom.this.threadLocalHolder.get().threadId, (int)this.getBits());
            }
        });
        parts.add(new BroIdPart(){

            public int getBits() {
                return 12;
            }

            public List<Boolean> next() {
                short s = BroIdGeneratorCustom.this.threadLocalHolder.get().sequence;
                BroIdGeneratorCustom.this.threadLocalHolder.get().sequence = (short)(s + 1);
                return BitUtils.longToList((long)s, (int)this.getBits());
            }
        });
        BroIdLayout layout = new BroIdLayout(parts);
        return new BroIdGeneratorCustom(layout, BroIdCustom::new);
    }

    public String generate() {
        return ((BroIdCustom)this.next()).toUUID().toString();
    }

    public IdType idType() {
        return IdType.BroId;
    }

    public static class BroIdThreadLocalHolder {
        short threadId;
        short sequence;

        @Generated
        public short getThreadId() {
            return this.threadId;
        }

        @Generated
        public short getSequence() {
            return this.sequence;
        }

        @Generated
        public void setThreadId(short threadId) {
            this.threadId = threadId;
        }

        @Generated
        public void setSequence(short sequence) {
            this.sequence = sequence;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BroIdThreadLocalHolder)) {
                return false;
            }
            BroIdThreadLocalHolder other = (BroIdThreadLocalHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getThreadId() != other.getThreadId()) {
                return false;
            }
            return this.getSequence() == other.getSequence();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BroIdThreadLocalHolder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getThreadId();
            result = result * 59 + this.getSequence();
            return result;
        }

        @Generated
        public String toString() {
            return "BroIdGeneratorCustom.BroIdThreadLocalHolder(threadId=" + this.getThreadId() + ", sequence=" + this.getSequence() + ")";
        }

        @Generated
        public BroIdThreadLocalHolder(short threadId, short sequence) {
            this.threadId = threadId;
            this.sequence = sequence;
        }
    }
}

