/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.broid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.distributed.broid.BroIdUltra;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import lombok.Generated;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;

@Component
public enum BroIdGeneratorUltra implements IdGenerator
{
    INSTANCE;

    @Resource
    private RedissonClient redisson;
    private RAtomicLong threadId;
    private ThreadLocal<BroIdThreadLocalHolder> threadLocalHolder;

    @PostConstruct
    public void init() {
        this.threadId = this.redisson.getAtomicLong("IdGenerator:BroIdGenerator:threadId");
        this.threadLocalHolder = ThreadLocal.withInitial(() -> {
            long currentThreadId = this.threadId.getAndIncrement();
            return new BroIdThreadLocalHolder((int)currentThreadId, 0);
        });
    }

    public BroIdUltra generate() {
        BroIdThreadLocalHolder holder = this.threadLocalHolder.get();
        return new BroIdUltra(BroIdUltra.currentNanoTimestamp(), holder.threadId, holder.sequence++);
    }

    public IdType idType() {
        return IdType.BroId;
    }

    public static class BroIdThreadLocalHolder {
        int threadId;
        int sequence;

        @Generated
        public BroIdThreadLocalHolder(int threadId, int sequence) {
            this.threadId = threadId;
            this.sequence = sequence;
        }
    }
}

