/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.mist;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.security.SecureRandom;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"redissonClient"})
public enum MistIdGenerator implements IdGenerator
{
    INSTANCE;

    @Resource
    private RedissonClient redisson;
    private RAtomicLong atomicLong;
    @Value(value="${id.generator.mist.name:IdGenerator:AtomicLongIdGenerator:current}")
    private String name;
    @Value(value="${id.generator.mist.value:-1}")
    private Long value;
    @Value(value="${id.generator.mist.secret:false}")
    private Boolean secret;
    @Value(value="${id.generator.mist.bufferSize:65536}")
    private Integer bufferSize;
    private Random random;
    private final Queue<Long> queue = new ConcurrentLinkedQueue<Long>();
    private final AtomicBoolean isFilling = new AtomicBoolean(false);

    private void fillQueue() {
        long e = this.atomicLong.getAndAdd((long)this.bufferSize.intValue());
        for (int i = 0; i < this.bufferSize; ++i) {
            this.queue.offer(e + (long)i);
        }
    }

    @PostConstruct
    public void init() {
        this.atomicLong = this.redisson.getAtomicLong(this.name);
        if (this.value >= 0L) {
            this.atomicLong.set(this.value.longValue());
        }
        this.random = this.secret != false ? new SecureRandom() : ThreadLocalRandom.current();
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.scheduleAtFixedRate(this::fillQueue, 0L, 10L, TimeUnit.MILLISECONDS);
        this.fillQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long generate() {
        MistIdGenerator mistIdGenerator = this;
        synchronized (mistIdGenerator) {
            if ((double)this.queue.size() < (double)this.bufferSize.intValue() * 0.1 && this.isFilling.compareAndSet(false, true)) {
                new Thread(() -> {
                    try {
                        this.fillQueue();
                    }
                    finally {
                        this.isFilling.set(false);
                    }
                }).start();
            }
        }
        return this.queue.remove() | (long)(this.random.nextInt() & 0xFFFF);
    }

    public IdType idType() {
        return IdType.MIST_ID;
    }
}

