/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.snowflake;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.distributor.MachineIdDistributor;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public enum LockFreeSnowflakeIdGenerator implements IdGenerator
{
    INSTANCE;

    @Value(value="${id.generator.snowflake.epoch:1645557742000}")
    private long epoch;
    @Value(value="${id.generator.snowflake.timestamp:41}")
    private long timestampBits;
    @Value(value="${id.generator.snowflake.machine:10}")
    private long machineIdBits;
    @Value(value="${id.generator.snowflake.sequence:12}")
    private long sequenceBits;
    private final AtomicLong lastTimestamp = new AtomicLong(-1L);
    @Resource
    private RedissonClient redisson;
    private MachineIdDistributor machineIdDistributor;
    private final AtomicLong sequence = new AtomicLong(0L);

    @PostConstruct
    public void init() {
        this.machineIdDistributor = new MachineIdDistributor(this.redisson, IdType.Snowflake.getName());
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    public Long generate() {
        long currentSequence;
        long timestamp;
        long currentLastTimestamp;
        do {
            currentLastTimestamp = this.lastTimestamp.get();
            timestamp = this.timeGen();
            if (timestamp < currentLastTimestamp) {
                throw new RuntimeException("\u65f6\u949f\u56de\u62e8\uff0c\u62d2\u7edd\u751f\u6210ID");
            }
            if (timestamp == currentLastTimestamp) {
                currentSequence = this.sequence.updateAndGet(seq -> seq + 1L & (-1L << (int)this.sequenceBits ^ 0xFFFFFFFFFFFFFFFFL));
                if (currentSequence != 0L) continue;
                timestamp = this.tilNextMillis(currentLastTimestamp);
                continue;
            }
            this.sequence.set(0L);
            currentSequence = 0L;
        } while (!this.lastTimestamp.compareAndSet(currentLastTimestamp, timestamp));
        return timestamp - this.epoch << (int)(this.machineIdBits + this.sequenceBits) | this.machineIdDistributor.get() << (int)this.sequenceBits | currentSequence;
    }

    public IdType idType() {
        return IdType.Snowflake;
    }
}

