/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.ttsid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.distributed.ttsid.TtsId;
import lombok.Generated;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;

@Component
public class TtsIdGenerator
implements IdGenerator {
    private final ThreadLocal<TtsIdThreadLocalHolder> threadLocalHolder;

    public TtsIdGenerator(RedissonClient redisson) {
        RAtomicLong threadId = redisson.getAtomicLong("IdGenerator:TtsIdGenerator:threadId");
        this.threadLocalHolder = ThreadLocal.withInitial(() -> new TtsIdThreadLocalHolder((short)threadId.getAndIncrement(), 0));
    }

    public TtsId generate() {
        TtsIdThreadLocalHolder holder = this.threadLocalHolder.get();
        short s = holder.sequence;
        holder.sequence = (short)(s + 1);
        return new TtsId(TtsId.currentTimestamp(), holder.threadId, s);
    }

    public IdType idType() {
        return IdType.TtsId;
    }

    private static class TtsIdThreadLocalHolder {
        short threadId;
        short sequence;

        @Generated
        public TtsIdThreadLocalHolder(short threadId, short sequence) {
            this.threadId = threadId;
            this.sequence = sequence;
        }
    }
}

