/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.ttsid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.distributed.ttsid.TtsIdProMax;
import lombok.Generated;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;

@Component
public class TtsIdProMaxGenerator
implements IdGenerator {
    private final ThreadLocal<TtsIdProMaxThreadLocalHolder> threadLocalHolder;

    public TtsIdProMaxGenerator(RedissonClient redisson) {
        RAtomicLong threadId = redisson.getAtomicLong("IdGenerator:TtsIdProMaxGenerator:threadId");
        this.threadLocalHolder = ThreadLocal.withInitial(() -> new TtsIdProMaxThreadLocalHolder((int)threadId.getAndIncrement(), 0));
    }

    public TtsIdProMax generate() {
        TtsIdProMaxThreadLocalHolder holder = this.threadLocalHolder.get();
        return new TtsIdProMax(TtsIdProMax.currentTimestamp(), holder.threadId, holder.sequence++);
    }

    public IdType idType() {
        return IdType.TtsId;
    }

    private static class TtsIdProMaxThreadLocalHolder {
        int threadId;
        int sequence;

        @Generated
        public TtsIdProMaxThreadLocalHolder(int threadId, int sequence) {
            this.threadId = threadId;
            this.sequence = sequence;
        }
    }
}

