/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.cosid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.distributed.cosid.CosId;
import icu.congee.id.generator.distributor.MachineIdDistributor;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CosIdGenerator
implements IdGenerator {
    private final long maxSequence;
    private final MachineIdDistributor machineIdDistributor;
    private final int timestampBits;
    private final int machineBits;
    private final int sequenceBits;
    private final long epoch;
    private long currentSequence = 0L;
    private long lastTimestamp = -1L;

    public CosIdGenerator(RedissonClient redisson, @Value(value="${id.generator.cosid.timestamp.bits:44}") int timestampBits, @Value(value="${id.generator.cosid.machine.bits:20}") int machineBits, @Value(value="${id.generator.cosid.sequence.bits:16}") int sequenceBits, @Value(value="${id.generator.cosid.epoch:1672502400000}") long epoch) {
        this.timestampBits = timestampBits;
        this.machineBits = machineBits;
        this.sequenceBits = sequenceBits;
        this.epoch = epoch;
        if (timestampBits + machineBits + sequenceBits != 80) {
            throw new IllegalArgumentException(String.format("\u4f4d\u6570\u5206\u914d\u603b\u548c\u5fc5\u987b\u4e3a80\u4f4d\uff0c\u5f53\u524d\u914d\u7f6e\uff1atimestamp=%d, machine=%d, sequence=%d, total=%d", timestampBits, machineBits, sequenceBits, timestampBits + machineBits + sequenceBits));
        }
        this.maxSequence = (1L << sequenceBits) - 1L;
        this.machineIdDistributor = new MachineIdDistributor(redisson, IdType.CosId.getName(), machineBits);
    }

    private void waitNextMillis(long lastTimestamp) {
        long timestamp = this.getCurrentTimestamp();
        while (timestamp <= lastTimestamp) {
            timestamp = this.getCurrentTimestamp();
        }
    }

    private long getCurrentTimestamp() {
        return System.currentTimeMillis() - this.epoch;
    }

    public synchronized CosId generate() {
        long timestamp = this.getCurrentTimestamp();
        if (timestamp < this.lastTimestamp) {
            long backwardMillis = this.lastTimestamp - timestamp;
            String errorMessage = String.format("\u65f6\u949f\u56de\u62e8\uff0c\u62d2\u7edd\u751f\u6210ID\uff0c\u56de\u62e8\u65f6\u95f4\uff1a%d\u6beb\u79d2", backwardMillis);
            throw new RuntimeException(errorMessage);
        }
        if (timestamp == this.lastTimestamp) {
            if (this.currentSequence >= this.maxSequence) {
                this.waitNextMillis(this.lastTimestamp);
                timestamp = this.getCurrentTimestamp();
                this.currentSequence = 0L;
            }
        } else {
            this.currentSequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return new CosId(timestamp, this.machineIdDistributor.get(), this.currentSequence++, this.timestampBits, this.machineBits, this.sequenceBits);
    }

    public IdType idType() {
        return IdType.CosId;
    }
}

