/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.mist;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.distributed.mist.MistId;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.redisson.api.RIdGenerator;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MistIdGenerator
implements IdGenerator {
    private final Random random;
    private final RIdGenerator generator;

    public MistIdGenerator(RedissonClient redisson, @Value(value="${id.generator.mist.name:IdGenerator:MistIdGenerator:current}") String name, @Value(value="${id.generator.mist.value:-1}") long initialValue, @Value(value="${id.generator.mist.secret:false}") boolean useSecureRandom, @Value(value="${id.generator.mist.bufferSize:1000}") int bufferSize) {
        this.random = useSecureRandom ? new SecureRandom() : ThreadLocalRandom.current();
        this.generator = redisson.getIdGenerator(name);
        this.generator.tryInit(initialValue, (long)bufferSize);
    }

    public MistId generate() {
        return new MistId(this.generator.nextId(), this.random.nextInt(0, 65535));
    }

    public IdType idType() {
        return IdType.MIST_ID;
    }
}

