/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.ttsid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.distributed.ttsid.TtsIdPlus;
import lombok.Generated;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;

@Component
public class TtsIdPlusGenerator
implements IdGenerator {
    private final ThreadLocal<TtsIdPlusThreadLocalHolder> threadLocalHolder;

    public TtsIdPlusGenerator(RedissonClient redisson) {
        RAtomicLong threadId = redisson.getAtomicLong("IdGenerator:TtsIdPlusGenerator:threadId");
        this.threadLocalHolder = ThreadLocal.withInitial(() -> new TtsIdPlusThreadLocalHolder((int)threadId.getAndIncrement(), 0));
    }

    public TtsIdPlus generate() {
        TtsIdPlusThreadLocalHolder holder = this.threadLocalHolder.get();
        short s = holder.sequence;
        holder.sequence = (short)(s + 1);
        return new TtsIdPlus(TtsIdPlus.currentTimestamp(), holder.threadId, s);
    }

    public IdType idType() {
        return IdType.TtsId;
    }

    private static class TtsIdPlusThreadLocalHolder {
        int threadId;
        short sequence;

        @Generated
        public TtsIdPlusThreadLocalHolder(int threadId, short sequence) {
            this.threadId = threadId;
            this.sequence = sequence;
        }
    }
}

