/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.ttsid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.distributed.ttsid.TtsIdPro;
import lombok.Generated;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;

@Component
public class TtsIdProGenerator
implements IdGenerator {
    private final ThreadLocal<TtsIdProThreadLocalHolder> threadLocalHolder;

    public TtsIdProGenerator(RedissonClient redisson) {
        RAtomicLong threadId = redisson.getAtomicLong("IdGenerator:TtsIdProGenerator:threadId");
        this.threadLocalHolder = ThreadLocal.withInitial(() -> new TtsIdProThreadLocalHolder((int)threadId.getAndIncrement(), 0));
    }

    public TtsIdPro generate() {
        TtsIdProThreadLocalHolder holder = this.threadLocalHolder.get();
        short s = holder.sequence;
        holder.sequence = (short)(s + 1);
        return new TtsIdPro(TtsIdPro.currentTimestamp(), holder.threadId, s);
    }

    public IdType idType() {
        return IdType.TtsId;
    }

    private static class TtsIdProThreadLocalHolder {
        int threadId;
        short sequence;

        @Generated
        public TtsIdProThreadLocalHolder(int threadId, short sequence) {
            this.threadId = threadId;
            this.sequence = sequence;
        }
    }
}

