/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.uuid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.distributed.uuid.UUIDv8;
import icu.congee.id.generator.distributor.MachineIdDistributor;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;

@Component
public class UUIDv8Generator
implements IdGenerator {
    private final MachineIdDistributor machineIdDistributor;
    private final AtomicLong atomicLong = new AtomicLong(0L);

    public UUIDv8Generator(RedissonClient redisson) {
        this.machineIdDistributor = new MachineIdDistributor(redisson, IdType.UUIDv8.getName(), 48);
    }

    public UUIDv8 generate() {
        Instant now = Instant.now();
        long timestamp = (now.getEpochSecond() * 1000000000L + (long)now.getNano()) / 10L;
        long clockSeq = this.atomicLong.getAndUpdate(x -> {
            if (x >= 16384L) {
                return 0L;
            }
            return x + 1L;
        });
        long node = this.machineIdDistributor.get();
        return new UUIDv8(timestamp, clockSeq, node);
    }

    public IdType idType() {
        return IdType.UUIDv8;
    }
}

