/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.distributed.wxseq;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.distributed.wxseq.WxSeq;
import org.redisson.api.RIdGenerator;
import org.redisson.api.RLocalCachedMap;
import org.redisson.api.RedissonClient;
import org.redisson.api.options.LocalCachedMapOptions;
import org.springframework.stereotype.Component;

@Component
public class WxSeqGenerator
implements IdGenerator {
    private final RedissonClient redisson;
    private final RLocalCachedMap<Long, RIdGenerator> generatorCache;

    public WxSeqGenerator(RedissonClient redisson) {
        this.redisson = redisson;
        this.generatorCache = redisson.getLocalCachedMap(LocalCachedMapOptions.name((String)"IdGenerator:WxSeqGenerator:generatorCache"));
    }

    public WxSeq generate() {
        throw new IllegalStateException("User ID required");
    }

    public WxSeq generate(Long userId) {
        RIdGenerator idGenerator = (RIdGenerator)this.generatorCache.computeIfAbsent((Object)userId, k -> {
            RIdGenerator gen = this.redisson.getIdGenerator("IdGenerator:WxSeqGenerator:userId:" + k);
            gen.tryInit(0L, 10000L);
            return gen;
        });
        return new WxSeq(userId, idGenerator.nextId());
    }

    public IdType idType() {
        return IdType.WxSeq;
    }
}

