/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.web.task;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.generator.web.service.IdService;
import jakarta.annotation.Resource;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class IdGeneratorTask {
    private static final Logger logger = LoggerFactory.getLogger(IdGeneratorTask.class);
    @Resource
    IdService idService;
    ServiceLoader<IdGenerator> loader = ServiceLoader.load(IdGenerator.class);

    @Scheduled(fixedRate=1L, timeUnit=TimeUnit.SECONDS)
    public void generate() {
        for (IdGenerator generator : this.loader) {
            Object id = generator.generate();
            this.idService.insert(generator.idType().getName(), id);
        }
    }
}

