/*
 * Decompiled with CFR 0.152.
 */
package icu.d4peng.cloud.common.auth.dao;

import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.Assert;

public class SaTokenRedisDao
implements SaTokenDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaTokenRedisDao.class);
    public StringRedisTemplate stringRedisTemplate;
    public RedisTemplate<String, Object> objectRedisTemplate;

    public SaTokenRedisDao(StringRedisTemplate stringRedisTemplate, RedisTemplate<String, Object> objectRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
        this.objectRedisTemplate = objectRedisTemplate;
        Assert.notNull((Object)this.stringRedisTemplate, (String)"string redis template can't be null");
        Assert.notNull(this.objectRedisTemplate, (String)"object redis template can't be null");
    }

    public String get(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    public void set(String key, String value, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        if (timeout == -1L) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
        } else {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, timeout, TimeUnit.SECONDS);
        }
    }

    public void update(String key, String value) {
        long expire = this.getTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.set(key, value, expire);
    }

    public void delete(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }

    public long getTimeout(String key) {
        Long expire = this.stringRedisTemplate.getExpire((Object)key);
        return expire == null ? -2L : expire;
    }

    public void updateTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getTimeout(key);
            if (expire == -1L) {
                LOGGER.info("forever");
            } else {
                this.set(key, this.get(key), timeout);
            }
            return;
        }
        this.stringRedisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
    }

    public Object getObject(String key) {
        return this.objectRedisTemplate.opsForValue().get((Object)key);
    }

    public void setObject(String key, Object object, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        if (timeout == -1L) {
            this.objectRedisTemplate.opsForValue().set((Object)key, object);
        } else {
            this.objectRedisTemplate.opsForValue().set((Object)key, object, timeout, TimeUnit.SECONDS);
        }
    }

    public void updateObject(String key, Object object) {
        long expire = this.getObjectTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.setObject(key, object, expire);
    }

    public void deleteObject(String key) {
        this.objectRedisTemplate.delete((Object)key);
    }

    public long getObjectTimeout(String key) {
        Long expire = this.objectRedisTemplate.getExpire((Object)key);
        return expire == null ? 0L : expire;
    }

    public void updateObjectTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getObjectTimeout(key);
            if (expire == -1L) {
                LOGGER.info("forever");
            } else {
                this.setObject(key, this.getObject(key), timeout);
            }
            return;
        }
        this.objectRedisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
    }

    public List<String> searchData(String prefix, String keyword, int start, int size) {
        Set keys = this.stringRedisTemplate.keys((Object)(prefix + "*" + keyword + "*"));
        if (keys == null) {
            return new ArrayList<String>();
        }
        ArrayList list = new ArrayList(keys);
        return SaFoxUtil.searchList(list, (int)start, (int)size);
    }
}

