/*
 * Decompiled with CFR 0.152.
 */
package icu.d4peng.cloud.common.auth.service.impl;

import com.alibaba.fastjson.JSON;
import icu.d4peng.cloud.common.auth.properties.JustAuthProperties;
import icu.d4peng.cloud.common.auth.service.JustAuthService;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthBaiduRequest;
import me.zhyd.oauth.request.AuthCodingRequest;
import me.zhyd.oauth.request.AuthDingTalkRequest;
import me.zhyd.oauth.request.AuthDouyinRequest;
import me.zhyd.oauth.request.AuthFacebookRequest;
import me.zhyd.oauth.request.AuthGiteeRequest;
import me.zhyd.oauth.request.AuthGithubRequest;
import me.zhyd.oauth.request.AuthGoogleRequest;
import me.zhyd.oauth.request.AuthLinkedinRequest;
import me.zhyd.oauth.request.AuthMiRequest;
import me.zhyd.oauth.request.AuthMicrosoftRequest;
import me.zhyd.oauth.request.AuthOschinaRequest;
import me.zhyd.oauth.request.AuthPinterestRequest;
import me.zhyd.oauth.request.AuthQqRequest;
import me.zhyd.oauth.request.AuthRenrenRequest;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.request.AuthStackOverflowRequest;
import me.zhyd.oauth.request.AuthTaobaoRequest;
import me.zhyd.oauth.request.AuthTeambitionRequest;
import me.zhyd.oauth.request.AuthToutiaoRequest;
import me.zhyd.oauth.request.AuthWeiboRequest;
import me.zhyd.oauth.utils.AuthStateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JustAuthServiceImpl
implements JustAuthService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JustAuthServiceImpl.class);
    private final JustAuthProperties justAuthProperties;

    public JustAuthServiceImpl(JustAuthProperties justAuthProperties) {
        this.justAuthProperties = justAuthProperties;
    }

    @Override
    public String getAuthorizeUrl(AuthDefaultSource authDefaultSource) {
        return this.getAuthRequest(authDefaultSource).authorize(AuthStateUtils.createState());
    }

    @Override
    public AuthUser getUserInfo(AuthDefaultSource authDefaultSource, AuthCallback callbackInfo) {
        AuthResponse response = this.getAuthRequest(authDefaultSource).login(callbackInfo);
        if (response.getCode() == AuthResponseStatus.SUCCESS.getCode()) {
            AuthUser authUser = (AuthUser)JSON.parseObject((String)JSON.toJSONString((Object)response.getData()), AuthUser.class);
            LOGGER.info(JSON.toJSONString((Object)response.getData()));
            return authUser;
        }
        LOGGER.error(response.getMsg());
        throw new AuthException(response.getMsg());
    }

    private AuthRequest getAuthRequest(AuthDefaultSource authSourceType) {
        AuthConfig authConfig = this.justAuthProperties.getTypes().get(authSourceType);
        if (authConfig == null) {
            LOGGER.error("auth not config,please check config!");
            throw new AuthException("auth not config,please check config!");
        }
        switch (authSourceType) {
            case GITHUB: {
                return new AuthGithubRequest(authConfig);
            }
            case WEIBO: {
                return new AuthWeiboRequest(authConfig);
            }
            case GITEE: {
                return new AuthGiteeRequest(authConfig);
            }
            case DINGTALK: {
                return new AuthDingTalkRequest(authConfig);
            }
            case BAIDU: {
                return new AuthBaiduRequest(authConfig);
            }
            case CODING: {
                return new AuthCodingRequest(authConfig);
            }
            case OSCHINA: {
                return new AuthOschinaRequest(authConfig);
            }
            case QQ: {
                return new AuthQqRequest(authConfig);
            }
            case TAOBAO: {
                return new AuthTaobaoRequest(authConfig);
            }
            case GOOGLE: {
                return new AuthGoogleRequest(authConfig);
            }
            case FACEBOOK: {
                return new AuthFacebookRequest(authConfig);
            }
            case DOUYIN: {
                return new AuthDouyinRequest(authConfig);
            }
            case LINKEDIN: {
                return new AuthLinkedinRequest(authConfig);
            }
            case MICROSOFT: {
                return new AuthMicrosoftRequest(authConfig);
            }
            case MI: {
                return new AuthMiRequest(authConfig);
            }
            case TOUTIAO: {
                return new AuthToutiaoRequest(authConfig);
            }
            case TEAMBITION: {
                return new AuthTeambitionRequest(authConfig);
            }
            case RENREN: {
                return new AuthRenrenRequest(authConfig);
            }
            case PINTEREST: {
                return new AuthPinterestRequest(authConfig);
            }
            case STACK_OVERFLOW: {
                return new AuthStackOverflowRequest(authConfig);
            }
        }
        throw new AuthException("auth type is null,please check!");
    }
}

