/*
 * Decompiled with CFR 0.152.
 */
package icu.d4peng.cloud.common.cache;

import icu.d4peng.cloud.common.cache.properties.CacheProperties;
import icu.d4peng.cloud.common.cache.service.CacheService;
import icu.d4peng.cloud.common.cache.service.impl.CacheServiceImpl;
import net.oschina.j2cache.J2CacheBuilder;
import net.oschina.j2cache.J2CacheConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CacheProperties.class})
@ConditionalOnProperty(prefix="roc.cache", name={"enabled"}, havingValue="true")
public class CacheAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={CacheService.class})
    public CacheService cacheService(CacheProperties cacheProperties) {
        return new CacheServiceImpl(J2CacheBuilder.init((J2CacheConfig)cacheProperties).getChannel());
    }
}

