/*
 * Decompiled with CFR 0.152.
 */
package icu.d4peng.cloud.common.cache.properties;

import icu.d4peng.cloud.common.cache.serializer.FastJSONSerializer;
import net.oschina.j2cache.J2CacheConfig;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="roc.cache")
public class CacheProperties
extends J2CacheConfig
implements InitializingBean {
    public static final String PREFIX = "roc.cache";
    private boolean enabled = true;

    public void afterPropertiesSet() {
        if (this.getSerialization() == null || this.getSerialization().equals("fastjson")) {
            this.setSerialization(FastJSONSerializer.class.getName());
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public CacheProperties setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String toString() {
        return "CacheProperties(enabled=" + this.isEnabled() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheProperties)) {
            return false;
        }
        CacheProperties other = (CacheProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isEnabled() == other.isEnabled();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CacheProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        return result;
    }
}

