/*
 * Decompiled with CFR 0.152.
 */
package icu.d4peng.cloud.common.captcha.service.impl;

import com.wf.captcha.ArithmeticCaptcha;
import com.wf.captcha.ChineseCaptcha;
import com.wf.captcha.ChineseGifCaptcha;
import com.wf.captcha.GifCaptcha;
import com.wf.captcha.SpecCaptcha;
import com.wf.captcha.base.Captcha;
import icu.d4peng.cloud.common.captcha.exception.CaptchaException;
import icu.d4peng.cloud.common.captcha.properties.CaptchaProperties;
import icu.d4peng.cloud.common.captcha.service.CaptchaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptchaServiceImpl
implements CaptchaService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaptchaServiceImpl.class);
    private final Captcha captcha;

    public CaptchaServiceImpl(CaptchaProperties captchaProperties) {
        switch (captchaProperties.getType()) {
            case Arithmetic: {
                this.captcha = new ArithmeticCaptcha();
                break;
            }
            case Chinese: {
                this.captcha = new ChineseCaptcha();
                break;
            }
            case ChineseGif: {
                this.captcha = new ChineseGifCaptcha();
                break;
            }
            case Gif: {
                this.captcha = new GifCaptcha();
                break;
            }
            case Spec: {
                this.captcha = new SpecCaptcha();
                break;
            }
            default: {
                throw new CaptchaException("captcha type nod found!");
            }
        }
        try {
            this.captcha.setFont(captchaProperties.getFontType());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new CaptchaException(e.getCause());
        }
        this.captcha.setCharType(captchaProperties.getTextType());
        this.captcha.setLen(captchaProperties.getTextLength());
        this.captcha.setHeight(captchaProperties.getHeight());
        this.captcha.setWidth(captchaProperties.getWidth());
    }

    @Override
    public Captcha getCaptcha() {
        return this.captcha;
    }

    @Override
    public String toBase64() {
        return this.captcha.toBase64();
    }
}

