/*
 * Decompiled with CFR 0.152.
 */
package icu.d4peng.cloud.common.core.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetUtils.class);

    private static InetAddress getInetAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOGGER.error(e.getMessage());
            return null;
        }
    }

    public static String getLocalHostName() {
        InetAddress inetAddress = NetUtils.getInetAddress();
        if (inetAddress != null) {
            return inetAddress.getHostName();
        }
        return "localhost";
    }

    public static String getLocalIP() {
        InetAddress inetAddress = NetUtils.getInetAddress();
        if (inetAddress != null) {
            return inetAddress.getHostAddress();
        }
        return "localhost";
    }
}

