/*
 * Decompiled with CFR 0.152.
 */
package icu.d4peng.cloud.common.core.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;

public class SpringAware
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringAware.class);
    private static ApplicationContext applicationContext;

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringAware.applicationContext = applicationContext;
    }

    public static <T> T getBean(Class<T> clz) {
        return (T)applicationContext.getBean(clz);
    }

    public static <T> void registerBean(String name, T bean) {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        beanFactory.autowireBean(bean);
        beanFactory.registerSingleton(bean.getClass().getName(), bean);
    }

    public static <T> void registerBean(T bean) {
        SpringAware.registerBean(bean.getClass().getSimpleName(), bean);
    }

    public static <T> void unregisterBean(String name) {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        beanFactory.destroyBean((Object)name);
    }

    public static <T> void unregisterBean(T bean) {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        beanFactory.destroyBean(bean);
    }

    public static Environment getEnvironment() {
        return applicationContext.getEnvironment();
    }

    public static String getEnvironmentProperty(String key) {
        return SpringAware.getEnvironment().getProperty(key);
    }
}

