/*
 * Decompiled with CFR 0.152.
 */
package icu.d4peng.cloud.common.http;

import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.config.SpringForestProperties;
import com.dtflys.forest.converter.ForestConverter;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.interceptor.SpringInterceptorFactory;
import com.dtflys.forest.logging.ForestLogHandler;
import com.dtflys.forest.reflection.SpringForestObjectFactory;
import com.dtflys.forest.scanner.ClassPathClientScanner;
import com.dtflys.forest.schema.ForestConfigurationBeanDefinitionParser;
import com.dtflys.forest.spring.ForestBeanProcessor;
import com.dtflys.forest.utils.ForestDataType;
import icu.d4peng.cloud.common.core.exception.InstanceException;
import icu.d4peng.cloud.common.http.properties.HttpConvertProperties;
import icu.d4peng.cloud.common.http.properties.HttpConverterItemProperties;
import icu.d4peng.cloud.common.http.properties.HttpProperties;
import icu.d4peng.cloud.common.http.properties.HttpSSLKeyStoreProperties;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={HttpProperties.class})
@ConditionalOnProperty(prefix="roc.http", name={"enabled"}, havingValue="true")
public class HttpAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ForestBeanProcessor forestBeanProcessor() {
        return new ForestBeanProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public ClassPathClientScanner classPathClientScanner(ConfigurableApplicationContext configurableApplicationContext, HttpProperties httpProperties) {
        BeanDefinitionBuilder forestConfigurationBuilder = BeanDefinitionBuilder.genericBeanDefinition(ForestConfiguration.class);
        Class<? extends ForestLogHandler> logHandlerClass = httpProperties.getLogHandler();
        ForestLogHandler logHandler = null;
        if (logHandlerClass != null) {
            try {
                logHandler = logHandlerClass.newInstance();
            }
            catch (Exception e) {
                throw new InstanceException((Throwable)e);
            }
        }
        forestConfigurationBuilder.addPropertyValue("maxAsyncThreadSize", (Object)httpProperties.getMaxAsyncThreadSize()).addPropertyValue("maxConnections", (Object)httpProperties.getMaxConnections()).addPropertyValue("maxRouteConnections", (Object)httpProperties.getMaxRouteConnections()).addPropertyValue("timeout", (Object)httpProperties.getTimeout()).addPropertyValue("connectTimeout", (Object)httpProperties.getConnectTimeout()).addPropertyValue("readTimeout", (Object)httpProperties.getReadTimeout()).addPropertyValue("charset", (Object)httpProperties.getCharset()).addPropertyValue("retryer", httpProperties.getRetryer()).addPropertyValue("maxRetryCount", (Object)httpProperties.getMaxRetryCount()).addPropertyValue("maxRetryInterval", (Object)httpProperties.getMaxRetryInterval()).addPropertyValue("autoRedirection", (Object)httpProperties.isAutoRedirection()).addPropertyValue("logEnabled", (Object)httpProperties.isLogEnabled()).addPropertyValue("logRequest", (Object)httpProperties.isLogRequest()).addPropertyValue("logResponseStatus", (Object)httpProperties.isLogResponseStatus()).addPropertyValue("logResponseContent", (Object)httpProperties.isLogResponseContent()).addPropertyValue("logHandler", (Object)logHandler).addPropertyValue("backendName", (Object)httpProperties.getBackend()).addPropertyValue("baseAddressScheme", (Object)httpProperties.getBaseAddressScheme()).addPropertyValue("baseAddressHost", (Object)httpProperties.getBaseAddressHost()).addPropertyValue("baseAddressPort", (Object)httpProperties.getBaseAddressPort()).addPropertyValue("baseAddressSourceClass", httpProperties.getBaseAddressSource()).addPropertyValue("successWhenClass", httpProperties.getSuccessWhen()).addPropertyValue("retryWhenClass", httpProperties.getRetryWhen()).addPropertyValue("interceptors", httpProperties.getInterceptors()).addPropertyValue("sslProtocol", (Object)httpProperties.getSslProtocol()).addPropertyValue("variables", httpProperties.getVariables()).setLazyInit(false).setFactoryMethod("configuration");
        BeanDefinition forestPropertiesBean = this.registerForestPropertiesBean(configurableApplicationContext);
        forestConfigurationBuilder.addPropertyValue("properties", (Object)forestPropertiesBean);
        BeanDefinition forestObjectFactoryBeanDefinition = this.registerForestObjectFactoryBean(configurableApplicationContext);
        forestConfigurationBuilder.addPropertyValue("forestObjectFactory", (Object)forestObjectFactoryBeanDefinition);
        BeanDefinition interceptorFactoryBeanDefinition = this.registerInterceptorFactoryBean(configurableApplicationContext);
        forestConfigurationBuilder.addPropertyValue("interceptorFactory", (Object)interceptorFactoryBeanDefinition);
        ManagedMap<String, BeanDefinition> sslKeystoreMap = this.generateSSLKeyStoreMapBean(httpProperties.getSslKeyStores());
        forestConfigurationBuilder.addPropertyValue("sslKeyStores", sslKeystoreMap);
        AbstractBeanDefinition beanDefinition = forestConfigurationBuilder.getRawBeanDefinition();
        beanDefinition.setRole(2);
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)configurableApplicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition(httpProperties.getBeanId(), (BeanDefinition)beanDefinition);
        ForestConfiguration forestConfiguration = (ForestConfiguration)configurableApplicationContext.getBean(httpProperties.getBeanId(), ForestConfiguration.class);
        Map<String, Class<?>> filters = httpProperties.getFilters();
        for (Map.Entry<String, Class<?>> entry : filters.entrySet()) {
            forestConfiguration.registerFilter(entry.getKey(), entry.getValue());
        }
        HttpConvertProperties httpConvertProperties = httpProperties.getConverters();
        if (httpConvertProperties != null) {
            this.registerConverter(forestConfiguration, ForestDataType.TEXT, httpConvertProperties.getText());
            this.registerConverter(forestConfiguration, ForestDataType.JSON, httpConvertProperties.getJson());
            this.registerConverter(forestConfiguration, ForestDataType.XML, httpConvertProperties.getXml());
            this.registerConverter(forestConfiguration, ForestDataType.BINARY, httpConvertProperties.getBinary());
            this.registerConverter(forestConfiguration, ForestDataType.PROTOBUF, httpConvertProperties.getProtobuf());
        }
        ClassPathClientScanner classPathClientScanner = new ClassPathClientScanner(httpProperties.getBeanId(), (BeanDefinitionRegistry)configurableApplicationContext.getBeanFactory());
        classPathClientScanner.doScan(AutoConfigurationPackages.get((BeanFactory)configurableApplicationContext.getBeanFactory()).toArray(new String[0]));
        return classPathClientScanner;
    }

    private BeanDefinition registerForestPropertiesBean(ConfigurableApplicationContext configurableApplicationContext) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(SpringForestProperties.class);
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        beanDefinition.setRole(2);
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)configurableApplicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition("forestProperties", (BeanDefinition)beanDefinition);
        return beanDefinition;
    }

    private BeanDefinition registerForestObjectFactoryBean(ConfigurableApplicationContext configurableApplicationContext) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(SpringForestObjectFactory.class);
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        beanDefinition.setRole(2);
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)configurableApplicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition("forestObjectFactory", (BeanDefinition)beanDefinition);
        return beanDefinition;
    }

    private BeanDefinition registerInterceptorFactoryBean(ConfigurableApplicationContext configurableApplicationContext) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(SpringInterceptorFactory.class);
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        beanDefinition.setRole(2);
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)configurableApplicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition("forestInterceptorFactory", (BeanDefinition)beanDefinition);
        return beanDefinition;
    }

    private ManagedMap<String, BeanDefinition> generateSSLKeyStoreMapBean(List<HttpSSLKeyStoreProperties> httpSSLKeyStorePropertiesList) {
        ManagedMap sslKeystoreMap = new ManagedMap();
        for (HttpSSLKeyStoreProperties httpSSLKeyStoreProperties : httpSSLKeyStorePropertiesList) {
            BeanDefinition beanDefinition = ForestConfigurationBeanDefinitionParser.createSSLKeyStoreBean((String)httpSSLKeyStoreProperties.getId(), (String)httpSSLKeyStoreProperties.getType(), (String)httpSSLKeyStoreProperties.getFile(), (String)httpSSLKeyStoreProperties.getKeystorePass(), (String)httpSSLKeyStoreProperties.getCertPass(), (String)httpSSLKeyStoreProperties.getProtocols(), (String)httpSSLKeyStoreProperties.getCipherSuites(), (String)httpSSLKeyStoreProperties.getHostnameVerifier(), (String)httpSSLKeyStoreProperties.getSslSocketFactoryBuilder());
            beanDefinition.setRole(2);
            sslKeystoreMap.put((Object)httpSSLKeyStoreProperties.getId(), (Object)beanDefinition);
        }
        return sslKeystoreMap;
    }

    private void registerConverter(ForestConfiguration configuration, ForestDataType dataType, HttpConverterItemProperties httpConverterItemProperties) {
        if (httpConverterItemProperties == null) {
            return;
        }
        Class<? extends ForestJsonConverter> type = httpConverterItemProperties.getType();
        if (type != null) {
            ForestConverter converter = null;
            try {
                PropertyDescriptor[] descriptors;
                Constructor<?>[] constructors;
                for (Constructor<?> constructor : constructors = type.getConstructors()) {
                    Parameter[] params = constructor.getParameters();
                    if (params.length == 0) {
                        converter = (ForestConverter)constructor.newInstance(new Object[0]);
                        break;
                    }
                    if (params.length != 1 || !ForestConfiguration.class.isAssignableFrom(constructor.getParameterTypes()[0])) continue;
                    converter = (ForestConverter)constructor.newInstance(constructor);
                    break;
                }
                Map<String, Object> parameters = httpConverterItemProperties.getParameters();
                for (PropertyDescriptor descriptor : descriptors = ReflectUtils.getBeanSetters(type)) {
                    String name = descriptor.getName();
                    Object value = parameters.get(name);
                    Method method = descriptor.getWriteMethod();
                    if (method == null) continue;
                    try {
                        method.invoke((Object)converter, value);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new ForestRuntimeException("An error occurred during setting the property " + type.getName() + "." + name, (Throwable)e);
                    }
                }
                configuration.getConverterMap().put(dataType, converter);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new ForestRuntimeException("[Forest] Convert type '" + type.getName() + "' cannot be initialized!", (Throwable)e);
            }
        }
    }
}

