/*
 * Decompiled with CFR 0.152.
 */
package icu.d4peng.cloud.common.http.properties;

import com.dtflys.forest.callback.AddressSource;
import com.dtflys.forest.callback.RetryWhen;
import com.dtflys.forest.callback.SuccessWhen;
import com.dtflys.forest.interceptor.Interceptor;
import com.dtflys.forest.logging.ForestLogHandler;
import com.dtflys.forest.retryer.BackOffRetryer;
import com.dtflys.forest.retryer.ForestRetryer;
import icu.d4peng.cloud.common.http.config.RocLogHandler;
import icu.d4peng.cloud.common.http.properties.HttpConvertProperties;
import icu.d4peng.cloud.common.http.properties.HttpSSLKeyStoreProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="roc.http")
public class HttpProperties {
    public static final String PREFIX = "roc.http";
    private boolean enabled = true;
    private String beanId = "forestConfiguration";
    private int maxConnections = 500;
    private int maxRouteConnections = 500;
    private int maxAsyncThreadSize = 100;
    private int timeout = 3000;
    private Integer connectTimeout = null;
    private Integer readTimeout = null;
    private String charset = "UTF-8";
    private String baseAddressScheme;
    private String baseAddressHost;
    private Integer baseAddressPort;
    private Class<? extends AddressSource> baseAddressSource;
    private Class<? extends ForestRetryer> retryer = BackOffRetryer.class;
    private Integer maxRetryCount = 0;
    private long maxRetryInterval = 0L;
    private boolean autoRedirection = true;
    private boolean logEnabled = true;
    private boolean logRequest = true;
    private boolean logResponseStatus = true;
    private boolean logResponseContent = false;
    private Class<? extends ForestLogHandler> logHandler = RocLogHandler.class;
    private String sslProtocol = "TLSv1.2";
    private String backend = "okhttp3";
    private Map<String, Object> variables = new HashMap<String, Object>();
    private List<Class<? extends Interceptor<?>>> interceptors = new ArrayList();
    private Class<? extends SuccessWhen> successWhen;
    private Class<? extends RetryWhen> retryWhen;
    private List<HttpSSLKeyStoreProperties> sslKeyStores = new ArrayList<HttpSSLKeyStoreProperties>();
    private HttpConvertProperties converters = new HttpConvertProperties();
    private Map<String, Class<?>> filters = new HashMap();

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getBeanId() {
        return this.beanId;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMaxRouteConnections() {
        return this.maxRouteConnections;
    }

    public int getMaxAsyncThreadSize() {
        return this.maxAsyncThreadSize;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getBaseAddressScheme() {
        return this.baseAddressScheme;
    }

    public String getBaseAddressHost() {
        return this.baseAddressHost;
    }

    public Integer getBaseAddressPort() {
        return this.baseAddressPort;
    }

    public Class<? extends AddressSource> getBaseAddressSource() {
        return this.baseAddressSource;
    }

    public Class<? extends ForestRetryer> getRetryer() {
        return this.retryer;
    }

    public Integer getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public boolean isAutoRedirection() {
        return this.autoRedirection;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public boolean isLogRequest() {
        return this.logRequest;
    }

    public boolean isLogResponseStatus() {
        return this.logResponseStatus;
    }

    public boolean isLogResponseContent() {
        return this.logResponseContent;
    }

    public Class<? extends ForestLogHandler> getLogHandler() {
        return this.logHandler;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public String getBackend() {
        return this.backend;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public List<Class<? extends Interceptor<?>>> getInterceptors() {
        return this.interceptors;
    }

    public Class<? extends SuccessWhen> getSuccessWhen() {
        return this.successWhen;
    }

    public Class<? extends RetryWhen> getRetryWhen() {
        return this.retryWhen;
    }

    public List<HttpSSLKeyStoreProperties> getSslKeyStores() {
        return this.sslKeyStores;
    }

    public HttpConvertProperties getConverters() {
        return this.converters;
    }

    public Map<String, Class<?>> getFilters() {
        return this.filters;
    }

    public HttpProperties setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public HttpProperties setBeanId(String beanId) {
        this.beanId = beanId;
        return this;
    }

    public HttpProperties setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public HttpProperties setMaxRouteConnections(int maxRouteConnections) {
        this.maxRouteConnections = maxRouteConnections;
        return this;
    }

    public HttpProperties setMaxAsyncThreadSize(int maxAsyncThreadSize) {
        this.maxAsyncThreadSize = maxAsyncThreadSize;
        return this;
    }

    public HttpProperties setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public HttpProperties setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public HttpProperties setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public HttpProperties setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public HttpProperties setBaseAddressScheme(String baseAddressScheme) {
        this.baseAddressScheme = baseAddressScheme;
        return this;
    }

    public HttpProperties setBaseAddressHost(String baseAddressHost) {
        this.baseAddressHost = baseAddressHost;
        return this;
    }

    public HttpProperties setBaseAddressPort(Integer baseAddressPort) {
        this.baseAddressPort = baseAddressPort;
        return this;
    }

    public HttpProperties setBaseAddressSource(Class<? extends AddressSource> baseAddressSource) {
        this.baseAddressSource = baseAddressSource;
        return this;
    }

    public HttpProperties setRetryer(Class<? extends ForestRetryer> retryer) {
        this.retryer = retryer;
        return this;
    }

    public HttpProperties setMaxRetryCount(Integer maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
        return this;
    }

    public HttpProperties setMaxRetryInterval(long maxRetryInterval) {
        this.maxRetryInterval = maxRetryInterval;
        return this;
    }

    public HttpProperties setAutoRedirection(boolean autoRedirection) {
        this.autoRedirection = autoRedirection;
        return this;
    }

    public HttpProperties setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
        return this;
    }

    public HttpProperties setLogRequest(boolean logRequest) {
        this.logRequest = logRequest;
        return this;
    }

    public HttpProperties setLogResponseStatus(boolean logResponseStatus) {
        this.logResponseStatus = logResponseStatus;
        return this;
    }

    public HttpProperties setLogResponseContent(boolean logResponseContent) {
        this.logResponseContent = logResponseContent;
        return this;
    }

    public HttpProperties setLogHandler(Class<? extends ForestLogHandler> logHandler) {
        this.logHandler = logHandler;
        return this;
    }

    public HttpProperties setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
        return this;
    }

    public HttpProperties setBackend(String backend) {
        this.backend = backend;
        return this;
    }

    public HttpProperties setVariables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public HttpProperties setInterceptors(List<Class<? extends Interceptor<?>>> interceptors) {
        this.interceptors = interceptors;
        return this;
    }

    public HttpProperties setSuccessWhen(Class<? extends SuccessWhen> successWhen) {
        this.successWhen = successWhen;
        return this;
    }

    public HttpProperties setRetryWhen(Class<? extends RetryWhen> retryWhen) {
        this.retryWhen = retryWhen;
        return this;
    }

    public HttpProperties setSslKeyStores(List<HttpSSLKeyStoreProperties> sslKeyStores) {
        this.sslKeyStores = sslKeyStores;
        return this;
    }

    public HttpProperties setConverters(HttpConvertProperties converters) {
        this.converters = converters;
        return this;
    }

    public HttpProperties setFilters(Map<String, Class<?>> filters) {
        this.filters = filters;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpProperties)) {
            return false;
        }
        HttpProperties other = (HttpProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getMaxConnections() != other.getMaxConnections()) {
            return false;
        }
        if (this.getMaxRouteConnections() != other.getMaxRouteConnections()) {
            return false;
        }
        if (this.getMaxAsyncThreadSize() != other.getMaxAsyncThreadSize()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        if (this.getMaxRetryInterval() != other.getMaxRetryInterval()) {
            return false;
        }
        if (this.isAutoRedirection() != other.isAutoRedirection()) {
            return false;
        }
        if (this.isLogEnabled() != other.isLogEnabled()) {
            return false;
        }
        if (this.isLogRequest() != other.isLogRequest()) {
            return false;
        }
        if (this.isLogResponseStatus() != other.isLogResponseStatus()) {
            return false;
        }
        if (this.isLogResponseContent() != other.isLogResponseContent()) {
            return false;
        }
        Integer this$connectTimeout = this.getConnectTimeout();
        Integer other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Integer this$readTimeout = this.getReadTimeout();
        Integer other$readTimeout = other.getReadTimeout();
        if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
            return false;
        }
        Integer this$baseAddressPort = this.getBaseAddressPort();
        Integer other$baseAddressPort = other.getBaseAddressPort();
        if (this$baseAddressPort == null ? other$baseAddressPort != null : !((Object)this$baseAddressPort).equals(other$baseAddressPort)) {
            return false;
        }
        Integer this$maxRetryCount = this.getMaxRetryCount();
        Integer other$maxRetryCount = other.getMaxRetryCount();
        if (this$maxRetryCount == null ? other$maxRetryCount != null : !((Object)this$maxRetryCount).equals(other$maxRetryCount)) {
            return false;
        }
        String this$beanId = this.getBeanId();
        String other$beanId = other.getBeanId();
        if (this$beanId == null ? other$beanId != null : !this$beanId.equals(other$beanId)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
            return false;
        }
        String this$baseAddressScheme = this.getBaseAddressScheme();
        String other$baseAddressScheme = other.getBaseAddressScheme();
        if (this$baseAddressScheme == null ? other$baseAddressScheme != null : !this$baseAddressScheme.equals(other$baseAddressScheme)) {
            return false;
        }
        String this$baseAddressHost = this.getBaseAddressHost();
        String other$baseAddressHost = other.getBaseAddressHost();
        if (this$baseAddressHost == null ? other$baseAddressHost != null : !this$baseAddressHost.equals(other$baseAddressHost)) {
            return false;
        }
        Class<? extends AddressSource> this$baseAddressSource = this.getBaseAddressSource();
        Class<? extends AddressSource> other$baseAddressSource = other.getBaseAddressSource();
        if (this$baseAddressSource == null ? other$baseAddressSource != null : !this$baseAddressSource.equals(other$baseAddressSource)) {
            return false;
        }
        Class<? extends ForestRetryer> this$retryer = this.getRetryer();
        Class<? extends ForestRetryer> other$retryer = other.getRetryer();
        if (this$retryer == null ? other$retryer != null : !this$retryer.equals(other$retryer)) {
            return false;
        }
        Class<? extends ForestLogHandler> this$logHandler = this.getLogHandler();
        Class<? extends ForestLogHandler> other$logHandler = other.getLogHandler();
        if (this$logHandler == null ? other$logHandler != null : !this$logHandler.equals(other$logHandler)) {
            return false;
        }
        String this$sslProtocol = this.getSslProtocol();
        String other$sslProtocol = other.getSslProtocol();
        if (this$sslProtocol == null ? other$sslProtocol != null : !this$sslProtocol.equals(other$sslProtocol)) {
            return false;
        }
        String this$backend = this.getBackend();
        String other$backend = other.getBackend();
        if (this$backend == null ? other$backend != null : !this$backend.equals(other$backend)) {
            return false;
        }
        Map<String, Object> this$variables = this.getVariables();
        Map<String, Object> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        List<Class<Interceptor<?>>> this$interceptors = this.getInterceptors();
        List<Class<? extends Interceptor<?>>> other$interceptors = other.getInterceptors();
        if (this$interceptors == null ? other$interceptors != null : !((Object)this$interceptors).equals(other$interceptors)) {
            return false;
        }
        Class<? extends SuccessWhen> this$successWhen = this.getSuccessWhen();
        Class<? extends SuccessWhen> other$successWhen = other.getSuccessWhen();
        if (this$successWhen == null ? other$successWhen != null : !this$successWhen.equals(other$successWhen)) {
            return false;
        }
        Class<? extends RetryWhen> this$retryWhen = this.getRetryWhen();
        Class<? extends RetryWhen> other$retryWhen = other.getRetryWhen();
        if (this$retryWhen == null ? other$retryWhen != null : !this$retryWhen.equals(other$retryWhen)) {
            return false;
        }
        List<HttpSSLKeyStoreProperties> this$sslKeyStores = this.getSslKeyStores();
        List<HttpSSLKeyStoreProperties> other$sslKeyStores = other.getSslKeyStores();
        if (this$sslKeyStores == null ? other$sslKeyStores != null : !((Object)this$sslKeyStores).equals(other$sslKeyStores)) {
            return false;
        }
        HttpConvertProperties this$converters = this.getConverters();
        HttpConvertProperties other$converters = other.getConverters();
        if (this$converters == null ? other$converters != null : !((Object)this$converters).equals(other$converters)) {
            return false;
        }
        Map<String, Class<?>> this$filters = this.getFilters();
        Map<String, Class<?>> other$filters = other.getFilters();
        return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getMaxConnections();
        result = result * 59 + this.getMaxRouteConnections();
        result = result * 59 + this.getMaxAsyncThreadSize();
        result = result * 59 + this.getTimeout();
        long $maxRetryInterval = this.getMaxRetryInterval();
        result = result * 59 + (int)($maxRetryInterval >>> 32 ^ $maxRetryInterval);
        result = result * 59 + (this.isAutoRedirection() ? 79 : 97);
        result = result * 59 + (this.isLogEnabled() ? 79 : 97);
        result = result * 59 + (this.isLogRequest() ? 79 : 97);
        result = result * 59 + (this.isLogResponseStatus() ? 79 : 97);
        result = result * 59 + (this.isLogResponseContent() ? 79 : 97);
        Integer $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Integer $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        Integer $baseAddressPort = this.getBaseAddressPort();
        result = result * 59 + ($baseAddressPort == null ? 43 : ((Object)$baseAddressPort).hashCode());
        Integer $maxRetryCount = this.getMaxRetryCount();
        result = result * 59 + ($maxRetryCount == null ? 43 : ((Object)$maxRetryCount).hashCode());
        String $beanId = this.getBeanId();
        result = result * 59 + ($beanId == null ? 43 : $beanId.hashCode());
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        String $baseAddressScheme = this.getBaseAddressScheme();
        result = result * 59 + ($baseAddressScheme == null ? 43 : $baseAddressScheme.hashCode());
        String $baseAddressHost = this.getBaseAddressHost();
        result = result * 59 + ($baseAddressHost == null ? 43 : $baseAddressHost.hashCode());
        Class<? extends AddressSource> $baseAddressSource = this.getBaseAddressSource();
        result = result * 59 + ($baseAddressSource == null ? 43 : $baseAddressSource.hashCode());
        Class<? extends ForestRetryer> $retryer = this.getRetryer();
        result = result * 59 + ($retryer == null ? 43 : $retryer.hashCode());
        Class<? extends ForestLogHandler> $logHandler = this.getLogHandler();
        result = result * 59 + ($logHandler == null ? 43 : $logHandler.hashCode());
        String $sslProtocol = this.getSslProtocol();
        result = result * 59 + ($sslProtocol == null ? 43 : $sslProtocol.hashCode());
        String $backend = this.getBackend();
        result = result * 59 + ($backend == null ? 43 : $backend.hashCode());
        Map<String, Object> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        List<Class<Interceptor<?>>> $interceptors = this.getInterceptors();
        result = result * 59 + ($interceptors == null ? 43 : ((Object)$interceptors).hashCode());
        Class<? extends SuccessWhen> $successWhen = this.getSuccessWhen();
        result = result * 59 + ($successWhen == null ? 43 : $successWhen.hashCode());
        Class<? extends RetryWhen> $retryWhen = this.getRetryWhen();
        result = result * 59 + ($retryWhen == null ? 43 : $retryWhen.hashCode());
        List<HttpSSLKeyStoreProperties> $sslKeyStores = this.getSslKeyStores();
        result = result * 59 + ($sslKeyStores == null ? 43 : ((Object)$sslKeyStores).hashCode());
        HttpConvertProperties $converters = this.getConverters();
        result = result * 59 + ($converters == null ? 43 : ((Object)$converters).hashCode());
        Map<String, Class<?>> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        return result;
    }

    public String toString() {
        return "HttpProperties(enabled=" + this.isEnabled() + ", beanId=" + this.getBeanId() + ", maxConnections=" + this.getMaxConnections() + ", maxRouteConnections=" + this.getMaxRouteConnections() + ", maxAsyncThreadSize=" + this.getMaxAsyncThreadSize() + ", timeout=" + this.getTimeout() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", charset=" + this.getCharset() + ", baseAddressScheme=" + this.getBaseAddressScheme() + ", baseAddressHost=" + this.getBaseAddressHost() + ", baseAddressPort=" + this.getBaseAddressPort() + ", baseAddressSource=" + this.getBaseAddressSource() + ", retryer=" + this.getRetryer() + ", maxRetryCount=" + this.getMaxRetryCount() + ", maxRetryInterval=" + this.getMaxRetryInterval() + ", autoRedirection=" + this.isAutoRedirection() + ", logEnabled=" + this.isLogEnabled() + ", logRequest=" + this.isLogRequest() + ", logResponseStatus=" + this.isLogResponseStatus() + ", logResponseContent=" + this.isLogResponseContent() + ", logHandler=" + this.getLogHandler() + ", sslProtocol=" + this.getSslProtocol() + ", backend=" + this.getBackend() + ", variables=" + this.getVariables() + ", interceptors=" + this.getInterceptors() + ", successWhen=" + this.getSuccessWhen() + ", retryWhen=" + this.getRetryWhen() + ", sslKeyStores=" + this.getSslKeyStores() + ", converters=" + this.getConverters() + ", filters=" + this.getFilters() + ")";
    }
}

