/*
 * Decompiled with CFR 0.152.
 */
package icu.d4peng.cloud.common.log.aspect;

import com.alibaba.fastjson.JSON;
import icu.d4peng.cloud.common.log.annotation.RocLog;
import java.util.ArrayList;
import java.util.Arrays;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class LogAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogAspect.class);

    @Pointcut(value="@annotation(icu.d4peng.cloud.common.log.annotation.RocLog)")
    public void annotationLog() {
    }

    @Pointcut(value="@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController)")
    public void controllerLog() {
    }

    @Around(value="annotationLog() || controllerLog()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        Object object;
        ArrayList<String> parameters = new ArrayList<String>();
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        long beginTime = System.currentTimeMillis();
        String className = pjp.getTarget().getClass().getName();
        String methodName = signature.getName();
        Object[] args = pjp.getArgs();
        parameters.add(Arrays.toString(args));
        RocLog rocLog = signature.getMethod().getAnnotation(RocLog.class);
        if (rocLog != null) {
            String values = rocLog.values();
            parameters.add(values);
        }
        Object returnValue = null;
        Exception exception = null;
        try {
            object = returnValue = pjp.proceed();
        }
        catch (Exception e) {
            try {
                exception = e;
                throw e;
            }
            catch (Throwable throwable) {
                long cost = System.currentTimeMillis() - beginTime;
                if (exception != null) {
                    LOGGER.error("[class: {}][method: {}][cost: {}ms][args: {}][exception: {}]", new Object[]{className, methodName, cost, parameters, exception});
                } else {
                    LOGGER.info("[class: {}][method: {}][cost: {}ms][args: {}][return: {}]", new Object[]{className, methodName, cost, parameters, JSON.toJSONString((Object)returnValue)});
                }
                throw throwable;
            }
        }
        long cost = System.currentTimeMillis() - beginTime;
        if (exception != null) {
            LOGGER.error("[class: {}][method: {}][cost: {}ms][args: {}][exception: {}]", new Object[]{className, methodName, cost, parameters, exception});
        } else {
            LOGGER.info("[class: {}][method: {}][cost: {}ms][args: {}][return: {}]", new Object[]{className, methodName, cost, parameters, JSON.toJSONString((Object)returnValue)});
        }
        return object;
    }
}

