/*
 * Decompiled with CFR 0.152.
 */
package icu.d4peng.cloud.common.log.core;

import icu.d4peng.cloud.common.core.util.NetUtils;
import icu.d4peng.cloud.common.log.context.LogContext;
import icu.d4peng.cloud.common.log.generator.LogGenerator;
import icu.d4peng.cloud.common.log.msg.LogMsg;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogCore {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogCore.class);

    public static void before(LogMsg logMsg) {
        if (StringUtils.isBlank((CharSequence)logMsg.getTraceId())) {
            String traceId = LogGenerator.generatorTraceId();
            logMsg.setTraceId(traceId);
        }
        LogContext.putTraceId(logMsg.getTraceId());
        if (StringUtils.isBlank((CharSequence)logMsg.getSpanId())) {
            String spanId = LogGenerator.generatorSpanId(logMsg.getSpanId());
            logMsg.setSpanId(spanId);
        }
        LogContext.putSpanId(logMsg.getSpanId());
        LogContext.putCurrentIP(NetUtils.getLocalIP());
        if (StringUtils.isBlank((CharSequence)logMsg.getPreAppName())) {
            logMsg.setPreAppName("NONE");
        }
        LogContext.putPreAppName(logMsg.getPreAppName());
        if (StringUtils.isBlank((CharSequence)logMsg.getPreHost())) {
            logMsg.setPreHost("NONE");
        }
        LogContext.putPreHost(logMsg.getPreHost());
        if (StringUtils.isBlank((CharSequence)logMsg.getPreIp())) {
            logMsg.setPreIp("NONE");
        }
        LogContext.putPreIP(logMsg.getPreIp());
        String label = LogGenerator.generateLogLabel(LogContext.getTraceId(), LogContext.getSpanId(), LogContext.getCurrentIP(), LogContext.getPreAppName(), LogContext.getPreHost(), LogContext.getPreIP());
        MDC.put((String)"roc", (String)label);
    }

    public static void after() {
        LogContext.removeTraceId();
        LogContext.removeSpanId();
        LogContext.removeCurrentIP();
        LogContext.removePreAppName();
        LogContext.removePreHost();
        LogContext.removePreIP();
    }

    public void process() {
    }
}

