/*
 * Decompiled with CFR 0.152.
 */
package icu.d4peng.cloud.common.log.generator;

import icu.d4peng.cloud.common.log.generator.spanid.DefaultSpanIdGenerator;
import icu.d4peng.cloud.common.log.generator.spanid.SpanIdGenerator;
import icu.d4peng.cloud.common.log.generator.traceid.DefaultTraceIdGenerator;
import icu.d4peng.cloud.common.log.generator.traceid.TraceIdGenerator;

public class LogGenerator {
    public static String labelPattern = "<$spanId><$traceId>";
    public static TraceIdGenerator traceIdGenerator = new DefaultTraceIdGenerator();
    public static SpanIdGenerator spanIdGenerator = new DefaultSpanIdGenerator();

    public static String generateLogLabel(String traceId, String spanId, String currentIp, String preAppName, String preHost, String preIp) {
        return labelPattern.replace("$traceId", traceId).replace("$spanId", spanId).replace("$currentIp", currentIp).replace("$preAppName", preAppName).replace("$preHost", preHost).replace("$preIp", preIp);
    }

    public static void setLabelPattern(String labelPattern) {
        LogGenerator.labelPattern = labelPattern;
    }

    public static String generatorTraceId() {
        return traceIdGenerator.generateTraceId();
    }

    public static void setTraceIdGenerator(TraceIdGenerator traceIdGenerator) {
        LogGenerator.traceIdGenerator = traceIdGenerator;
    }

    public static String generatorSpanId(String spanId) {
        return spanIdGenerator.generateNextSpanId(spanId);
    }

    public static SpanIdGenerator getSpanIdGenerator() {
        return spanIdGenerator;
    }

    public static void setSpanIdGenerator(SpanIdGenerator spanIdGenerator) {
        LogGenerator.spanIdGenerator = spanIdGenerator;
    }
}

