/*
 * Decompiled with CFR 0.152.
 */
package icu.d4peng.cloud.common.log.properties;

import icu.d4peng.cloud.common.log.generator.LogGenerator;
import icu.d4peng.cloud.common.log.generator.spanid.SpanIdGenerator;
import icu.d4peng.cloud.common.log.generator.traceid.TraceIdGenerator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="roc.log")
public class LogProperties
implements InitializingBean {
    public static final String PREFIX = "roc.log";
    private boolean enabled = true;
    private String mdcPattern = "<traceId:$traceId><spanId:$spanId><currentIp:$currentIp><preAppName:$preAppName><preHost:$preHost><preIp:$preIp>";
    private String traceIdGenerator = "icu.d4peng.cloud.common.log.generator.traceid.DefaultTraceIdGenerator";
    private String spanIdGenerator = "icu.d4peng.cloud.common.log.generator.spanid.DefaultSpanIdGenerator";
    private boolean enableAopLog = false;
    private String path = "/opt/logs/";

    public void afterPropertiesSet() throws Exception {
        LogGenerator.setLabelPattern(this.mdcPattern);
        Class<?> traceIdGeneratorClass = Class.forName(this.traceIdGenerator);
        TraceIdGenerator traceIdGenerator = (TraceIdGenerator)traceIdGeneratorClass.newInstance();
        LogGenerator.setTraceIdGenerator(traceIdGenerator);
        Class<?> spanIdGeneratorClass = Class.forName(this.spanIdGenerator);
        SpanIdGenerator spanIdGenerator = (SpanIdGenerator)spanIdGeneratorClass.newInstance();
        LogGenerator.setSpanIdGenerator(spanIdGenerator);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getMdcPattern() {
        return this.mdcPattern;
    }

    public String getTraceIdGenerator() {
        return this.traceIdGenerator;
    }

    public String getSpanIdGenerator() {
        return this.spanIdGenerator;
    }

    public boolean isEnableAopLog() {
        return this.enableAopLog;
    }

    public String getPath() {
        return this.path;
    }

    public LogProperties setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public LogProperties setMdcPattern(String mdcPattern) {
        this.mdcPattern = mdcPattern;
        return this;
    }

    public LogProperties setTraceIdGenerator(String traceIdGenerator) {
        this.traceIdGenerator = traceIdGenerator;
        return this;
    }

    public LogProperties setSpanIdGenerator(String spanIdGenerator) {
        this.spanIdGenerator = spanIdGenerator;
        return this;
    }

    public LogProperties setEnableAopLog(boolean enableAopLog) {
        this.enableAopLog = enableAopLog;
        return this;
    }

    public LogProperties setPath(String path) {
        this.path = path;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogProperties)) {
            return false;
        }
        LogProperties other = (LogProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isEnableAopLog() != other.isEnableAopLog()) {
            return false;
        }
        String this$mdcPattern = this.getMdcPattern();
        String other$mdcPattern = other.getMdcPattern();
        if (this$mdcPattern == null ? other$mdcPattern != null : !this$mdcPattern.equals(other$mdcPattern)) {
            return false;
        }
        String this$traceIdGenerator = this.getTraceIdGenerator();
        String other$traceIdGenerator = other.getTraceIdGenerator();
        if (this$traceIdGenerator == null ? other$traceIdGenerator != null : !this$traceIdGenerator.equals(other$traceIdGenerator)) {
            return false;
        }
        String this$spanIdGenerator = this.getSpanIdGenerator();
        String other$spanIdGenerator = other.getSpanIdGenerator();
        if (this$spanIdGenerator == null ? other$spanIdGenerator != null : !this$spanIdGenerator.equals(other$spanIdGenerator)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isEnableAopLog() ? 79 : 97);
        String $mdcPattern = this.getMdcPattern();
        result = result * 59 + ($mdcPattern == null ? 43 : $mdcPattern.hashCode());
        String $traceIdGenerator = this.getTraceIdGenerator();
        result = result * 59 + ($traceIdGenerator == null ? 43 : $traceIdGenerator.hashCode());
        String $spanIdGenerator = this.getSpanIdGenerator();
        result = result * 59 + ($spanIdGenerator == null ? 43 : $spanIdGenerator.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    public String toString() {
        return "LogProperties(enabled=" + this.isEnabled() + ", mdcPattern=" + this.getMdcPattern() + ", traceIdGenerator=" + this.getTraceIdGenerator() + ", spanIdGenerator=" + this.getSpanIdGenerator() + ", enableAopLog=" + this.isEnableAopLog() + ", path=" + this.getPath() + ")";
    }
}

