/*
 * Decompiled with CFR 0.152.
 */
package icu.d4peng.cloud.common.log.web;

import icu.d4peng.cloud.common.core.util.NetUtils;
import icu.d4peng.cloud.common.log.core.LogCore;
import icu.d4peng.cloud.common.log.msg.LogMsg;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class LogGatewayInterceptor
implements GlobalFilter,
Ordered {
    private static final Integer FIRST = 0;
    @Value(value="${spring.application.name}")
    private String appName;

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        List preIps;
        List preHosts;
        List preAppNames;
        List spanIds;
        String traceId = null;
        String spanId = null;
        String preAppName = null;
        String preHost = null;
        String preIp = null;
        HttpHeaders headers = exchange.getRequest().getHeaders();
        List traceIds = headers.get((Object)"traceID");
        if (traceIds != null && traceIds.size() > 0) {
            traceId = (String)traceIds.get(FIRST);
        }
        if ((spanIds = headers.get((Object)"spanId")) != null && spanIds.size() > 0) {
            spanId = (String)spanIds.get(FIRST);
        }
        if ((preAppNames = headers.get((Object)"preAppName")) != null && preAppNames.size() > 0) {
            preAppName = (String)preAppNames.get(FIRST);
        }
        if ((preHosts = headers.get((Object)"preHost")) != null && preHosts.size() > 0) {
            preHost = (String)preHosts.get(FIRST);
        }
        if ((preIps = headers.get((Object)"preIp")) != null && preIps.size() > 0) {
            preIp = (String)preIps.get(FIRST);
        }
        LogMsg logMsg = new LogMsg().setTraceId(traceId).setSpanId(spanId).setPreAppName(preAppName).setPreHost(preHost).setPreIp(preIp);
        LogCore.before(logMsg);
        Consumer<HttpHeaders> httpHeaders = httpHeader -> {
            httpHeader.set("traceID", logMsg.getTraceId());
            httpHeader.set("spanId", logMsg.getSpanId());
            httpHeader.set("preAppName", this.appName);
            httpHeader.set("preHost", NetUtils.getLocalHostName());
            httpHeader.set("preIp", NetUtils.getLocalHostName());
        };
        ServerHttpRequest serverHttpRequest = exchange.getRequest().mutate().headers(httpHeaders).build();
        exchange = exchange.mutate().request(serverHttpRequest).build();
        return chain.filter(exchange).doFinally(signalType -> LogCore.after());
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

