/*
 * Decompiled with CFR 0.152.
 */
package icu.d4peng.cloud.common.log.web;

import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.interceptor.Interceptor;
import icu.d4peng.cloud.common.core.util.NetUtils;
import icu.d4peng.cloud.common.core.util.SpringAware;
import icu.d4peng.cloud.common.log.context.LogContext;
import icu.d4peng.cloud.common.log.generator.LogGenerator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogHttpInterceptor
implements Interceptor<Object> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public boolean beforeExecute(ForestRequest request) {
        String traceId = LogContext.getTraceId();
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            String appName = SpringAware.getEnvironmentProperty((String)"spring.application.name");
            request.addHeader("traceID", (Object)traceId);
            request.addHeader("spanId", (Object)LogGenerator.generatorSpanId(LogContext.getSpanId()));
            request.addHeader("preAppName", (Object)appName);
            request.addHeader("preHost", (Object)NetUtils.getLocalHostName());
            request.addHeader("preIp", (Object)NetUtils.getLocalIP());
        } else {
            this.log.debug("[TLOG]\u672c\u5730threadLocal\u53d8\u91cf\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u8c03\u7528\u4e0d\u4f20\u9012traceId");
        }
        return true;
    }
}

