/*
 * Decompiled with CFR 0.152.
 */
package icu.d4peng.cloud.common.message;

import icu.d4peng.cloud.common.message.properties.EmailProperties;
import icu.d4peng.cloud.common.message.service.EmailService;
import icu.d4peng.cloud.common.message.service.impl.EmailServiceImpl;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
@EnableConfigurationProperties(value={EmailProperties.class})
@ConditionalOnProperty(prefix="roc.email", value={"enabled"}, havingValue="true", matchIfMissing=true)
public class EmailAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={TemplateEngine.class})
    public TemplateEngine templateEngine(EmailProperties emailProperties, @Autowired ResourceLoader resourceLoader) {
        FileTemplateResolver fileTemplateResolver = new FileTemplateResolver();
        fileTemplateResolver.setPrefix(emailProperties.getTemplatePrefix());
        fileTemplateResolver.setSuffix(emailProperties.getTemplateSuffix());
        fileTemplateResolver.setTemplateMode(TemplateMode.HTML);
        fileTemplateResolver.setCacheable(true);
        TemplateEngine templateEngine = new TemplateEngine();
        templateEngine.setDialect((IDialect)new StandardDialect());
        templateEngine.setTemplateResolver((ITemplateResolver)fileTemplateResolver);
        return templateEngine;
    }

    @Bean
    @ConditionalOnMissingBean(value={JavaMailSender.class})
    public JavaMailSender mailSender(EmailProperties emailProperties) {
        JavaMailSenderImpl javaMailSender = new JavaMailSenderImpl();
        javaMailSender.setHost(emailProperties.getHost());
        if (emailProperties.getPort() != null) {
            javaMailSender.setPort(emailProperties.getPort().intValue());
        }
        javaMailSender.setUsername(emailProperties.getUsername());
        javaMailSender.setPassword(emailProperties.getPassword());
        javaMailSender.setProtocol(emailProperties.getProtocol());
        if (emailProperties.getDefaultEncoding() != null) {
            javaMailSender.setDefaultEncoding(emailProperties.getDefaultEncoding().name());
        }
        if (!emailProperties.getProperties().isEmpty()) {
            Properties tmpProperties = new Properties();
            tmpProperties.putAll((Map<?, ?>)emailProperties.getProperties());
            javaMailSender.setJavaMailProperties(tmpProperties);
        }
        return javaMailSender;
    }

    @Bean
    @ConditionalOnMissingBean(value={EmailService.class})
    public EmailService emailService(EmailProperties emailProperties, JavaMailSender javaMailSender, TemplateEngine templateEngine) {
        return new EmailServiceImpl(emailProperties, javaMailSender, templateEngine);
    }
}

