/*
 * Decompiled with CFR 0.152.
 */
package icu.d4peng.cloud.common.message.service.impl;

import icu.d4peng.cloud.common.message.properties.EmailProperties;
import icu.d4peng.cloud.common.message.service.EmailService;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

public class EmailServiceImpl
implements EmailService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailServiceImpl.class);
    private final TemplateEngine templateEngine;
    private final JavaMailSender javaMailSender;
    private final EmailProperties emailProperties;
    private final MimeMessage mimeMessage;
    private final MimeMessageHelper mimeMessageHelper;

    public EmailServiceImpl(EmailProperties emailProperties, JavaMailSender javaMailSender, TemplateEngine templateEngine) {
        this.emailProperties = emailProperties;
        this.templateEngine = templateEngine;
        this.javaMailSender = javaMailSender;
        this.mimeMessage = this.javaMailSender.createMimeMessage();
        try {
            this.mimeMessageHelper = new MimeMessageHelper(this.mimeMessage, true);
        }
        catch (MessagingException e) {
            LOGGER.error(e.getMessage());
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public void sendTextEmail(String to, String subject, String context) {
        try {
            this.mimeMessageHelper.setTo(to);
            this.mimeMessageHelper.setSubject(subject);
            this.mimeMessageHelper.setText(context, false);
            this.mimeMessageHelper.setFrom(this.emailProperties.getUsername());
        }
        catch (MessagingException e) {
            LOGGER.error(e.getMessage());
            throw new RuntimeException(e.getCause());
        }
        this.javaMailSender.send(this.mimeMessage);
        this.javaMailSender.send(this.mimeMessage);
    }

    @Override
    public void sendHtmlEmail(String to, String subject, String templateName, Map<String, Object> context) {
        try {
            this.mimeMessageHelper.setTo(to);
            this.mimeMessageHelper.setSubject(subject);
            this.mimeMessageHelper.setText(this.mapConvertTemplate(templateName, context), true);
            this.mimeMessageHelper.setFrom(this.emailProperties.getUsername());
        }
        catch (MessagingException e) {
            LOGGER.error(e.getMessage());
            throw new RuntimeException(e.getCause());
        }
        this.javaMailSender.send(this.mimeMessage);
        this.javaMailSender.send(this.mimeMessage);
    }

    private String mapConvertTemplate(String templateName, Map<String, Object> map) {
        Context context = new Context();
        context.setVariables(map);
        return this.templateEngine.process(templateName, (IContext)context);
    }
}

