/*
 * Decompiled with CFR 0.152.
 */
package icu.d4peng.cloud.common.mvc;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import icu.d4peng.cloud.common.mvc.config.LocalDateTimeConverter;
import icu.d4peng.cloud.common.mvc.properties.MvcProperties;
import icu.d4peng.cloud.common.mvc.test.DefaultErrorController;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="roc.mvc", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={MvcProperties.class})
@AutoConfigureBefore(value={WebMvcAutoConfiguration.class, ErrorMvcAutoConfiguration.class})
public class MvcAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MvcAutoConfiguration.class);

    @ConditionalOnProperty(prefix="roc.mvc", name={"enable-default-errors-handler"}, havingValue="true")
    @ConditionalOnMissingBean(value={DefaultErrorController.class})
    @Bean
    public DefaultErrorController defaultErrorController() {
        return new DefaultErrorController((ErrorAttributes)new DefaultErrorAttributes());
    }

    @Bean
    @ConditionalOnMissingBean(value={Jackson2ObjectMapperBuilderCustomizer.class})
    public Jackson2ObjectMapperBuilderCustomizer jackson2ObjectMapperBuilderCustomizer(MvcProperties mvcProperties) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(mvcProperties.getGlobalTimeFormatRegex());
        return builder -> {
            builder.serializerByType(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(dateTimeFormatter));
            builder.deserializerByType(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(dateTimeFormatter));
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={LocalDateTimeConverter.class})
    public LocalDateTimeConverter localDateTimeConverter() {
        return new LocalDateTimeConverter();
    }
}

