/*
 * Decompiled with CFR 0.152.
 */
package icu.d4peng.cloud.common.mvc.config;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;

public class LocalDateTimeConverter
implements Converter<String, LocalDateTime> {
    private final DateTimeFormatter YYYY_MM = DateTimeFormatter.ofPattern("yyyy-MM");
    private final DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final DateTimeFormatter YYYY_MM_DD_HH_MM = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private final DateTimeFormatter YYYY_MM_DD_HH_MM_SS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public LocalDateTime convert(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        if ((source = source.trim()).matches("^\\d{4}-\\d{1,2}$")) {
            return LocalDateTime.parse(source, this.YYYY_MM);
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2}$")) {
            return LocalDateTime.parse(source, this.YYYY_MM_DD);
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}$")) {
            return LocalDateTime.parse(source, this.YYYY_MM_DD_HH_MM);
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$")) {
            return LocalDateTime.parse(source, this.YYYY_MM_DD_HH_MM_SS);
        }
        throw new IllegalArgumentException("Invalid false value '" + source + "'");
    }
}

