/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.apiwrap;

import icu.develop.apiwrap.WrapBeanFactoryUtils;
import icu.develop.apiwrap.WrapData;
import icu.develop.apiwrap.WrapHandler;
import icu.develop.apiwrap.WrapRequest;
import icu.develop.apiwrap.annotation.ApiWrap;
import icu.develop.apiwrap.exception.InvalidWrapSignatureException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.AnnotationUtils;

@Aspect
@Primary
public class ApiWrapAspect {
    @Pointcut(value="@within(icu.develop.apiwrap.annotation.ApiWrap) || @annotation(icu.develop.apiwrap.annotation.ApiWrap)")
    public void apiWrapPointcut() {
    }

    @Before(value="apiWrapPointcut()")
    public void before(JoinPoint joinPoint) {
        MethodSignature sign = (MethodSignature)joinPoint.getSignature();
        Method method = sign.getMethod();
        ApiWrap wrapAnnotation = (ApiWrap)AnnotationUtils.findAnnotation((Method)method, ApiWrap.class);
        if (wrapAnnotation == null) {
            wrapAnnotation = (ApiWrap)AnnotationUtils.findAnnotation(joinPoint.getTarget().getClass(), ApiWrap.class);
        }
        Objects.requireNonNull(wrapAnnotation);
        Class<? extends WrapHandler> clazz = wrapAnnotation.value();
        WrapHandler wrapHandler = WrapBeanFactoryUtils.getBean(clazz);
        Object[] args = joinPoint.getArgs();
        if (args == null || args.length == 0) {
            throw new InvalidWrapSignatureException("\u7b7e\u540d\u6709\u8bef");
        }
        for (Object obj : args) {
            if (!(obj instanceof WrapRequest)) continue;
            WrapRequest request = (WrapRequest)obj;
            this.verify(wrapHandler, (WrapRequest<WrapData>)request);
        }
    }

    private void verify(WrapHandler wrapHandler, WrapRequest<WrapData> request) {
        long timestamp = request.getTimestamp();
        wrapHandler.isLegalTime(timestamp);
        String appKey = request.getAppKey();
        int nonce = request.getNonce();
        String signatureParam = request.getSignature();
        wrapHandler.isReplayAttack(appKey, timestamp, nonce, signatureParam);
        if (!wrapHandler.verifySignature(appKey, request)) {
            throw new InvalidWrapSignatureException("\u7b7e\u540d\u95ee\u9898");
        }
    }
}

