/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.apiwrap;

import icu.develop.apiwrap.ApiWrapAspect;
import icu.develop.apiwrap.ApiWrapEnablerConfiguration;
import icu.develop.apiwrap.ApiWrapProperties;
import icu.develop.apiwrap.WrapBeanFactoryUtils;
import icu.develop.apiwrap.WrapHandler;
import icu.develop.apiwrap.WrapStore;
import icu.develop.apiwrap.handler.WrapHandlerServer;
import icu.develop.apiwrap.store.LocalWrapStore;
import icu.develop.apiwrap.store.RedisWrapStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@ConditionalOnBean(value={ApiWrapEnablerConfiguration.Marker.class})
@EnableConfigurationProperties(value={ApiWrapProperties.class})
@Import(value={AopAutoConfiguration.class})
public class ApiWrapAutoConfiguration {
    @Bean
    public ApiWrapAspect apiWrapAspect() {
        return new ApiWrapAspect();
    }

    @Bean
    public WrapHandler defaultWrapHandler(@Autowired ApiWrapProperties apiWrapProperties, @Autowired WrapStore wrapStore) {
        return new WrapHandlerServer(apiWrapProperties, wrapStore);
    }

    @Bean
    public WrapBeanFactoryUtils wrapBeanFactoryUtils() {
        return new WrapBeanFactoryUtils();
    }

    @Bean
    @ConditionalOnMissingClass(value={"org.springframework.data.redis.core.StringRedisTemplate"})
    @ConditionalOnMissingBean
    public WrapStore localWrapStore(@Autowired ApiWrapProperties apiWrapProperties) {
        return new LocalWrapStore(apiWrapProperties);
    }

    @Configuration
    @ConditionalOnClass(value={StringRedisTemplate.class})
    static class RedisWrapStoreConfiguration {
        RedisWrapStoreConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public WrapStore redisWrapStore(@Autowired ApiWrapProperties apiWrapProperties, @Autowired StringRedisTemplate stringRedisTemplate) {
            return new RedisWrapStore(apiWrapProperties, stringRedisTemplate);
        }
    }
}

