/*
 * Decompiled with CFR 0.152.
 */
package icu.develop.apiwrap.handler;

import icu.develop.apiwrap.ApiWrapProperties;
import icu.develop.apiwrap.WrapData;
import icu.develop.apiwrap.WrapHandler;
import icu.develop.apiwrap.WrapRequest;
import icu.develop.apiwrap.WrapStore;
import icu.develop.apiwrap.exception.WrapReplayAttackException;
import icu.develop.apiwrap.exception.WrapTimestampException;
import icu.develop.apiwrap.handler.DefaultWrapSigner;
import java.util.concurrent.TimeUnit;
import org.springframework.util.StringUtils;

public class WrapHandlerServer
implements WrapHandler {
    private final Boolean enableSign;
    private final Long legalTime;
    private final String defaultSecret;
    private final WrapStore wrapStore;

    public WrapHandlerServer(ApiWrapProperties apiWrapProperties, WrapStore wrapStore) {
        this.enableSign = apiWrapProperties.getSign();
        this.legalTime = apiWrapProperties.getLegalTime() == null ? 300L : apiWrapProperties.getLegalTime();
        this.defaultSecret = apiWrapProperties.getSecret();
        this.wrapStore = wrapStore;
    }

    @Override
    public String getAppSecret(String appKey) {
        String secret = this.wrapStore.getSecret(appKey);
        if (StringUtils.isEmpty((Object)secret)) {
            return this.defaultSecret;
        }
        return secret;
    }

    @Override
    public boolean verifySignature(String appKey, WrapRequest<WrapData> request) {
        if (this.enableSign.booleanValue()) {
            DefaultWrapSigner wrapSigner = new DefaultWrapSigner(this.getAppSecret(appKey));
            String signature = wrapSigner.signature(request);
            String signatureParam = request.getSignature();
            return signatureParam.equals(signature);
        }
        return true;
    }

    @Override
    public void isLegalTime(long timestamp) {
        long diff = TimeUnit.MILLISECONDS.toSeconds(timestamp - System.currentTimeMillis());
        if (Math.abs(diff) > this.legalTime) {
            throw new WrapTimestampException(String.valueOf(diff));
        }
    }

    @Override
    public void isReplayAttack(String appKey, long timestamp, int nonce, String signature) {
        String sign = this.wrapStore.getSign(appKey, timestamp, nonce);
        if (signature.equals(sign)) {
            throw new WrapReplayAttackException(String.format("ReplayAttackException, appKey:%s, timestamp:%s, nonce:%s", appKey, timestamp, nonce));
        }
        this.wrapStore.putSign(appKey, timestamp, nonce, signature);
    }
}

